/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.toolkit.express;

import com.tc.object.DistributedObjectClient;
import com.terracotta.toolkit.express.ClientHandle;
import java.util.Set;

public class ClientHandleImpl
implements ClientHandle {
    private final DistributedObjectClient client;

    public ClientHandleImpl(Object client) {
        this.client = (DistributedObjectClient)client;
    }

    @Override
    public void activateTunnelledMBeanDomains(Set<String> tunnelledMBeanDomains) {
        boolean sendCurrentTunnelledDomains = false;
        if (tunnelledMBeanDomains != null) {
            for (String mbeanDomain : tunnelledMBeanDomains) {
                this.client.addTunneledMBeanDomain(mbeanDomain);
                sendCurrentTunnelledDomains = true;
            }
        }
        if (sendCurrentTunnelledDomains) {
            this.client.getTunneledDomainManager().sendCurrentTunneledDomains();
        }
    }

    @Override
    public void shutdown() {
        this.client.shutdown();
    }

    @Override
    public boolean isOnline() {
        return this.client.getPlatformService().getDsoCluster().areOperationsEnabled();
    }

    @Override
    public Object getPlatformService() {
        return this.client.getPlatformService();
    }
}

