/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics.extended;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.terracotta.statistics.archive.Timestamped;
import org.terracotta.statistics.extended.CompoundOperation;
import org.terracotta.statistics.extended.CountOperation;
import org.terracotta.statistics.extended.Latency;
import org.terracotta.statistics.extended.Result;
import org.terracotta.statistics.extended.SampledStatistic;

public final class NullCompoundOperation<T extends Enum<T>>
implements CompoundOperation<T> {
    private static final CompoundOperation INSTANCE = new NullCompoundOperation();

    private NullCompoundOperation() {
    }

    public static <T extends Enum<T>> CompoundOperation<T> instance(Class<T> klazz) {
        return INSTANCE;
    }

    @Override
    public Class<T> type() {
        return null;
    }

    @Override
    public Result component(T result) {
        return NullOperation.instance();
    }

    @Override
    public Result compound(Set<T> results) {
        return NullOperation.instance();
    }

    @Override
    public CountOperation<T> asCountOperation() {
        return new CountOperation<T>(){

            @Override
            public long value(T result) {
                return -1L;
            }

            @Override
            public long value(T ... results) {
                return -1L;
            }
        };
    }

    @Override
    public SampledStatistic<Double> ratioOf(Set<T> numerator, Set<T> denomiator) {
        return NullSampledStatistic.instance(Double.NaN);
    }

    @Override
    public boolean expire(long expiry) {
        return false;
    }

    @Override
    public void setAlwaysOn(boolean enable) {
    }

    @Override
    public void setWindow(long time, TimeUnit unit) {
    }

    @Override
    public void setHistory(int samples, long time, TimeUnit unit) {
    }

    @Override
    public boolean isAlwaysOn() {
        return false;
    }

    @Override
    public long getWindowSize(TimeUnit unit) {
        return 0L;
    }

    @Override
    public int getHistorySampleSize() {
        return 0;
    }

    @Override
    public long getHistorySampleTime(TimeUnit unit) {
        return 0L;
    }

    static final class NullSampledStatistic<T extends Number>
    implements SampledStatistic<T> {
        private static final Map<Object, SampledStatistic<?>> COMMON = new HashMap();
        private final T value;

        private NullSampledStatistic(T value) {
            this.value = value;
        }

        @Override
        public boolean active() {
            return false;
        }

        @Override
        public T value() {
            return this.value;
        }

        @Override
        public List<Timestamped<T>> history() throws UnsupportedOperationException {
            return Collections.emptyList();
        }

        static <T extends Number> SampledStatistic<T> instance(T value) {
            SampledStatistic<?> cached = COMMON.get(value);
            if (cached == null) {
                return new NullSampledStatistic<T>(value);
            }
            return cached;
        }

        static {
            COMMON.put(Double.NaN, new NullSampledStatistic<Double>(Double.NaN));
            COMMON.put(Float.valueOf(Float.NaN), new NullSampledStatistic<Float>(Float.valueOf(Float.NaN)));
            COMMON.put(0L, new NullSampledStatistic<Long>(0L));
            COMMON.put(null, new NullSampledStatistic<Object>(null));
        }
    }

    static final class NullLatency
    implements Latency {
        private static final Latency INSTANCE = new NullLatency();

        private NullLatency() {
        }

        static Latency instance() {
            return INSTANCE;
        }

        @Override
        public SampledStatistic<Long> minimum() {
            return NullSampledStatistic.instance(null);
        }

        @Override
        public SampledStatistic<Long> maximum() {
            return NullSampledStatistic.instance(null);
        }

        @Override
        public SampledStatistic<Double> average() {
            return NullSampledStatistic.instance(Double.NaN);
        }
    }

    static final class NullOperation
    implements Result {
        private static final Result INSTANCE = new NullOperation();

        private NullOperation() {
        }

        static final Result instance() {
            return INSTANCE;
        }

        @Override
        public SampledStatistic<Long> count() {
            return NullSampledStatistic.instance(0L);
        }

        @Override
        public SampledStatistic<Double> rate() {
            return NullSampledStatistic.instance(Double.NaN);
        }

        @Override
        public Latency latency() throws UnsupportedOperationException {
            return NullLatency.instance();
        }
    }
}

