/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics.extended;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.terracotta.statistics.Time;
import org.terracotta.statistics.ValueStatistic;
import org.terracotta.statistics.archive.Timestamped;
import org.terracotta.statistics.extended.AbstractSampledStatistic;

public class SemiExpiringSampledStatistic<T extends Number>
extends AbstractSampledStatistic<T> {
    private boolean active = false;
    private long touchTimestamp = -1L;

    public SemiExpiringSampledStatistic(ValueStatistic<T> source, ScheduledExecutorService executor, int historySize, long historyTime, TimeUnit historyTimeUnit) {
        super(source, executor, historySize, historyTime, historyTimeUnit);
    }

    @Override
    public List<Timestamped<T>> history() {
        this.touch();
        return super.history();
    }

    @Override
    public final synchronized boolean active() {
        return this.active;
    }

    protected final synchronized void touch() {
        this.touchTimestamp = Time.absoluteTime();
        this.start();
    }

    protected final synchronized void start() {
        if (!this.active) {
            this.startStatistic();
            this.startSampling();
            this.active = true;
        }
    }

    protected final synchronized boolean expire(long expiry) {
        if (this.touchTimestamp < expiry) {
            if (this.active) {
                this.stopSampling();
                this.stopStatistic();
                this.active = false;
            }
            return true;
        }
        return false;
    }

    protected void stopStatistic() {
    }

    protected void startStatistic() {
    }
}

