/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.upgradability.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;

public class SerializationUpgradabilityTesting {
    private static final Comparator<Object> EQUALS_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            return -1;
        }
    };

    public static void validateSerializedForm(Serializable o, String ... serializedFormResources) throws IOException, ClassNotFoundException {
        SerializationUpgradabilityTesting.validateSerializedForm(o, EQUALS_COMPARATOR, serializedFormResources);
    }

    public static void validateSerializedForm(Serializable o, URL ... serializedFormUrls) throws IOException, ClassNotFoundException {
        SerializationUpgradabilityTesting.validateSerializedForm(o, EQUALS_COMPARATOR, serializedFormUrls);
    }

    public static <T extends Serializable> void validateSerializedForm(T o, Comparator<? super T> comparator, String ... serializedFormResources) throws IOException, ClassNotFoundException {
        SerializationUpgradabilityTesting.validateSerializedForm(o, comparator, SerializationUpgradabilityTesting.getResources(o.getClass().getClassLoader(), serializedFormResources));
    }

    public static <T extends Serializable> void validateSerializedForm(T o, Comparator<? super T> comparator, URL ... serializedFormUrls) throws IOException, ClassNotFoundException {
        byte[] inputForm = SerializationUpgradabilityTesting.serialize(o);
        List<byte[]> validForms = SerializationUpgradabilityTesting.extractAll(Arrays.asList(serializedFormUrls));
        try {
            Assert.assertThat(validForms, (Matcher)IsCollectionContaining.hasItem(SerializationUpgradabilityTesting.arrayEquals(inputForm)));
        }
        catch (AssertionError e) {
            File f = SerializationUpgradabilityTesting.dumpSerializedForm(o, inputForm);
            AssertionError e2 = new AssertionError((Object)("Unrecognized serialized form saved to " + f.getAbsolutePath()));
            ((Throwable)((Object)e2)).initCause((Throwable)((Object)e));
            throw e2;
        }
        for (byte[] form : validForms) {
            Assert.assertThat((Object)comparator.compare(o, (Serializable)SerializationUpgradabilityTesting.deserialize(form)), (Matcher)Is.is((Object)0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] serialize(Serializable o) throws IOException {
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();
             ObjectOutputStream oout = new ObjectOutputStream(bout);){
            oout.writeObject(o);
        }
        return bout.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object deserialize(byte[] serialized) throws IOException, ClassNotFoundException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(serialized);){
            Object object;
            ObjectInputStream oin = new ObjectInputStream(in);
            try {
                object = oin.readObject();
            }
            catch (Throwable throwable) {
                oin.close();
                throw throwable;
            }
            oin.close();
            return object;
        }
    }

    private static List<byte[]> extractAll(List<URL> urls) throws IOException {
        ArrayList<byte[]> forms = new ArrayList<byte[]>(urls.size());
        for (URL url : urls) {
            forms.add(SerializationUpgradabilityTesting.extract(url));
        }
        return forms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] extract(URL url) throws IOException {
        try (InputStream in = url.openStream();){
            try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
                byte[] buffer = new byte[4096];
                int copied = 0;
                while ((copied = in.read(buffer)) != -1) {
                    bout.write(buffer, 0, copied);
                }
            }
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
    }

    private static Matcher<byte[]> arrayEquals(final byte[] array) {
        return new TypeSafeMatcher<byte[]>(){

            protected boolean matchesSafely(byte[] item) {
                return Arrays.equals(array, item);
            }

            public void describeTo(Description description) {
                description.appendText("array equal to").appendValue((Object)array);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File dumpSerializedForm(Serializable o, byte[] inputForm) throws IOException {
        File f;
        String nameStem = o.getClass().getSimpleName();
        int i = 0;
        while ((f = new File(nameStem + "-" + i + ".ser")).exists()) {
            ++i;
        }
        try (FileOutputStream fout = new FileOutputStream(f);){
            fout.write(inputForm);
        }
        return f;
    }

    private static URL[] getResources(ClassLoader loader, String ... serializedFormResources) {
        URL[] urls = new URL[serializedFormResources.length];
        for (int i = 0; i < serializedFormResources.length; ++i) {
            URL url = loader.getResource(serializedFormResources[i]);
            if (url == null) {
                throw new IllegalArgumentException("Could not find serialized form " + serializedFormResources[i]);
            }
            urls[i] = url;
        }
        return urls;
    }

    public static boolean nullSafeEquals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }
}

