/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.upgradability.interaction.localtoolkit.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.terracotta.toolkit.internal.ToolkitLogger;
import org.terracotta.upgradability.interaction.localtoolkit.object.LocalToolkitObject;

public class LocalLogger
extends LocalToolkitObject
implements ToolkitLogger {
    private final Logger backing;

    public LocalLogger(String name) {
        super(name);
        this.backing = Logger.getLogger(LocalLogger.class.getName() + "." + name);
    }

    public void debug(Object message) {
        this.backing.log(Level.FINE, message.toString());
    }

    public void debug(Object message, Throwable t) {
        this.backing.log(Level.FINE, message.toString(), t);
    }

    public void info(Object message) {
        this.backing.log(Level.INFO, message.toString());
    }

    public void info(Object message, Throwable t) {
        this.backing.log(Level.INFO, message.toString(), t);
    }

    public void warn(Object message) {
        this.backing.log(Level.WARNING, message.toString());
    }

    public void warn(Object message, Throwable t) {
        this.backing.log(Level.WARNING, message.toString(), t);
    }

    public void error(Object message) {
        this.backing.log(Level.SEVERE, message.toString());
    }

    public void error(Object message, Throwable t) {
        this.backing.log(Level.SEVERE, message.toString(), t);
    }

    public void fatal(Object message) {
        this.backing.log(Level.SEVERE, message.toString());
    }

    public void fatal(Object message, Throwable t) {
        this.backing.log(Level.SEVERE, message.toString(), t);
    }

    public boolean isDebugEnabled() {
        return this.backing.isLoggable(Level.FINE);
    }

    public boolean isInfoEnabled() {
        return this.backing.isLoggable(Level.INFO);
    }
}

