/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.upgradability.interaction.localtoolkit.feature;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.terracotta.toolkit.ToolkitObjectType;
import org.terracotta.toolkit.feature.NonStopFeature;
import org.terracotta.toolkit.nonstop.NonStopConfiguration;
import org.terracotta.toolkit.nonstop.NonStopConfigurationRegistry;

public class LocalNonStopFeature
implements NonStopFeature {
    private final NonStopConfigurationRegistry configRegistry = new LocalConfigRegistry();

    public void start(NonStopConfiguration nonStopConfig) {
    }

    public void finish() {
    }

    public boolean isTimedOut() {
        return false;
    }

    public NonStopConfigurationRegistry getNonStopConfigurationRegistry() {
        return this.configRegistry;
    }

    public boolean isEnabled() {
        throw new UnsupportedOperationException();
    }

    static class InstanceKey {
        private final ToolkitObjectType type;
        private final String name;

        InstanceKey(ToolkitObjectType type, String name) {
            this.type = type;
            this.name = name;
        }

        public int hashCode() {
            return this.type.hashCode() ^ this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof InstanceKey) {
                InstanceKey ok = (InstanceKey)o;
                return this.type.equals((Object)ok.type) && this.name.equals(ok.name);
            }
            return false;
        }
    }

    static class LocalConfigRegistry
    implements NonStopConfigurationRegistry {
        private final Map<Object, NonStopConfiguration> configs = new ConcurrentHashMap<Object, NonStopConfiguration>();

        LocalConfigRegistry() {
        }

        public void registerForType(NonStopConfiguration config, ToolkitObjectType ... types) {
            for (ToolkitObjectType type : types) {
                this.configs.put(type, config);
            }
        }

        public void registerForInstance(NonStopConfiguration config, String toolkitTypeName, ToolkitObjectType type) {
            this.configs.put(new InstanceKey(type, toolkitTypeName), config);
        }

        public void registerForTypeMethod(NonStopConfiguration config, String methodName, ToolkitObjectType type) {
        }

        public void registerForInstanceMethod(NonStopConfiguration config, String methodName, String toolkitTypeName, ToolkitObjectType type) {
        }

        public void registerTimeoutForSearch(long timeout, String instanceName, ToolkitObjectType objectType) {
        }

        public NonStopConfiguration getConfigForType(ToolkitObjectType type) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public NonStopConfiguration getConfigForInstance(String toolkitTypeName, ToolkitObjectType type) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public NonStopConfiguration getConfigForTypeMethod(String methodName, ToolkitObjectType type) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public NonStopConfiguration getConfigForInstanceMethod(String methodName, String toolkitTypeName, ToolkitObjectType type) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getTimeoutForSearch(String instanceName, ToolkitObjectType objectType) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public NonStopConfiguration deregisterForType(ToolkitObjectType type) {
            return this.configs.remove(type);
        }

        public NonStopConfiguration deregisterForInstance(String toolkitTypeName, ToolkitObjectType type) {
            return this.configs.remove(new InstanceKey(type, toolkitTypeName));
        }

        public NonStopConfiguration deregisterForTypeMethod(String methodName, ToolkitObjectType type) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public NonStopConfiguration deregisterForInstanceMethod(String methodName, String toolkitTypeName, ToolkitObjectType type) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long deregisterTimeoutForSearch(String instanceName, ToolkitObjectType objectType) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

