/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.upgradability.interaction.localtoolkit.concurrent.locks;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.terracotta.toolkit.concurrent.locks.ToolkitLock;
import org.terracotta.toolkit.concurrent.locks.ToolkitLockType;

public abstract class LocalLock
implements ToolkitLock {
    private final Lock lock;
    private final ToolkitLockType type;
    private final Condition theCondition;

    public LocalLock(Lock lock, ToolkitLockType type) {
        Condition singleCondition;
        this.lock = lock;
        this.type = type;
        try {
            singleCondition = lock.newCondition();
        }
        catch (UnsupportedOperationException e) {
            singleCondition = null;
        }
        this.theCondition = singleCondition;
    }

    public Condition newCondition() throws UnsupportedOperationException {
        return this.lock.newCondition();
    }

    public Condition getCondition() {
        if (this.theCondition == null) {
            throw new UnsupportedOperationException();
        }
        return this.theCondition;
    }

    public ToolkitLockType getLockType() {
        return this.type;
    }

    public void lock() {
        this.lock.lock();
    }

    public void lockInterruptibly() throws InterruptedException {
        this.lock.lockInterruptibly();
    }

    public boolean tryLock() {
        return this.lock.tryLock();
    }

    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return this.lock.tryLock(time, unit);
    }

    public void unlock() {
        this.lock.unlock();
    }
}

