/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.upgradability.interaction.localtoolkit.collections;

import java.util.ListIterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.terracotta.upgradability.interaction.localtoolkit.collections.LockedIterator;

public class LockedListIterator<E>
extends LockedIterator<E>
implements ListIterator<E> {
    public LockedListIterator(ReadWriteLock lock, ListIterator<E> delegate) {
        super(lock, delegate);
    }

    @Override
    public boolean hasPrevious() {
        Lock l = this.lock.readLock();
        l.lock();
        try {
            boolean bl = ((ListIterator)this.delegate).hasPrevious();
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public E previous() {
        Lock l = this.lock.readLock();
        l.lock();
        try {
            Object e = ((ListIterator)this.delegate).previous();
            return e;
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public int nextIndex() {
        Lock l = this.lock.readLock();
        l.lock();
        try {
            int n = ((ListIterator)this.delegate).nextIndex();
            return n;
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public int previousIndex() {
        Lock l = this.lock.readLock();
        l.lock();
        try {
            int n = ((ListIterator)this.delegate).previousIndex();
            return n;
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public void set(E e) {
        Lock l = this.lock.writeLock();
        l.lock();
        try {
            ((ListIterator)this.delegate).set(e);
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public void add(E e) {
        Lock l = this.lock.writeLock();
        l.lock();
        try {
            ((ListIterator)this.delegate).add(e);
        }
        finally {
            l.unlock();
        }
    }
}

