/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.upgradability.interaction.localtoolkit.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.terracotta.upgradability.interaction.localtoolkit.collections.LockedIterator;

public class LockedCollection<E>
implements Collection<E> {
    private final Collection<E> delegate;
    private final ReadWriteLock lock;

    public LockedCollection(ReadWriteLock lock, Collection<E> delegate) {
        this.delegate = delegate;
        this.lock = lock;
    }

    @Override
    public int size() {
        Lock l = this.lock.readLock();
        l.lock();
        try {
            int n = this.delegate.size();
            return n;
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        Lock l = this.lock.readLock();
        l.lock();
        try {
            boolean bl = this.delegate.isEmpty();
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        Lock l = this.lock.readLock();
        l.lock();
        try {
            boolean bl = this.delegate.contains(o);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        Lock l = this.lock.readLock();
        l.lock();
        try {
            LockedIterator<E> lockedIterator = new LockedIterator<E>(this.lock, this.delegate.iterator());
            return lockedIterator;
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public Object[] toArray() {
        Lock l = this.lock.readLock();
        l.lock();
        try {
            Object[] objectArray = this.delegate.toArray();
            return objectArray;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        Lock l = this.lock.readLock();
        l.lock();
        try {
            T[] TArray = this.delegate.toArray(a);
            return TArray;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        Lock l = this.lock.writeLock();
        l.lock();
        try {
            boolean bl = this.delegate.add(e);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        Lock l = this.lock.writeLock();
        l.lock();
        try {
            boolean bl = this.delegate.remove(o);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        Lock l = this.lock.readLock();
        l.lock();
        try {
            boolean bl = this.delegate.containsAll(c);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        Lock l = this.lock.writeLock();
        l.lock();
        try {
            boolean bl = this.delegate.addAll(c);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        Lock l = this.lock.writeLock();
        l.lock();
        try {
            boolean bl = this.delegate.removeAll(c);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        Lock l = this.lock.writeLock();
        l.lock();
        try {
            boolean bl = this.delegate.retainAll(c);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public void clear() {
        Lock l = this.lock.writeLock();
        l.lock();
        try {
            this.delegate.clear();
        }
        finally {
            l.unlock();
        }
    }
}

