/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.upgradability.interaction.localtoolkit.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import org.terracotta.toolkit.collections.ToolkitMap;
import org.terracotta.toolkit.concurrent.locks.ToolkitLock;
import org.terracotta.toolkit.concurrent.locks.ToolkitReadWriteLock;
import org.terracotta.upgradability.interaction.localtoolkit.collections.LockedCollection;
import org.terracotta.upgradability.interaction.localtoolkit.collections.LockedSet;
import org.terracotta.upgradability.interaction.localtoolkit.concurrent.locks.AnonymousLocalReadWriteLock;
import org.terracotta.upgradability.interaction.localtoolkit.object.LocalDestroyableToolkitObject;

public class LocalMap<K, V>
extends LocalDestroyableToolkitObject
implements ToolkitMap<K, V> {
    private final ToolkitReadWriteLock lock = new AnonymousLocalReadWriteLock();
    private final Map<K, V> backing = new HashMap();

    public LocalMap(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putIfAbsent(K key, V value) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            if (this.backing.containsKey(key)) {
                V v = this.backing.get(key);
                return v;
            }
            this.backing.put(key, value);
            V v = null;
            return v;
        }
        finally {
            l.unlock();
        }
    }

    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public V replace(K key, V value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int size() {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            int n = this.backing.size();
            return n;
        }
        finally {
            l.unlock();
        }
    }

    public boolean isEmpty() {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            boolean bl = this.backing.isEmpty();
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            boolean bl = this.backing.containsKey(key);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            boolean bl = this.backing.containsValue(value);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(Object key) {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            V v = this.backing.get(key);
            return v;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            V v = this.backing.put(key, value);
            return v;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(Object key) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            V v = this.backing.remove(key);
            return v;
        }
        finally {
            l.unlock();
        }
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public void clear() {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            this.backing.clear();
        }
        finally {
            l.unlock();
        }
    }

    public Set<K> keySet() {
        return new LockedSet<K>((ReadWriteLock)this.lock, this.backing.keySet());
    }

    public Collection<V> values() {
        return new LockedCollection<V>((ReadWriteLock)this.lock, this.backing.values());
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return new LockedSet<Map.Entry<K, V>>((ReadWriteLock)this.lock, this.backing.entrySet());
    }

    public ToolkitReadWriteLock getReadWriteLock() {
        return this.lock;
    }
}

