/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.upgradability.interaction.localtoolkit.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import org.terracotta.toolkit.collections.ToolkitBlockingQueue;
import org.terracotta.toolkit.concurrent.locks.ToolkitLock;
import org.terracotta.toolkit.concurrent.locks.ToolkitReadWriteLock;
import org.terracotta.upgradability.interaction.localtoolkit.collections.LockedIterator;
import org.terracotta.upgradability.interaction.localtoolkit.concurrent.locks.AnonymousLocalReadWriteLock;
import org.terracotta.upgradability.interaction.localtoolkit.object.LocalDestroyableToolkitObject;

public class LocalBlockingQueue<E>
extends LocalDestroyableToolkitObject
implements ToolkitBlockingQueue<E> {
    private final ToolkitReadWriteLock lock = new AnonymousLocalReadWriteLock();
    private final BlockingQueue<E> backing;

    public LocalBlockingQueue(String name, Class<E> type) {
        super(name);
        this.backing = new LinkedBlockingQueue();
    }

    public LocalBlockingQueue(String name, int capacity, Class<E> type) {
        super(name);
        this.backing = new LinkedBlockingDeque(capacity);
    }

    public int getCapacity() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(E e) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            boolean bl = this.backing.add(e);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(E e) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            boolean bl = this.backing.offer(e);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    public void put(E e) throws InterruptedException {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            this.backing.put(e);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            boolean bl = this.backing.offer(e, timeout, unit);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    public E take() throws InterruptedException {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            E e = this.backing.take();
            return e;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            E e = this.backing.poll(timeout, unit);
            return e;
        }
        finally {
            l.unlock();
        }
    }

    public int remainingCapacity() {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            int n = this.backing.remainingCapacity();
            return n;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            boolean bl = this.backing.remove(o);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            boolean bl = this.backing.contains(o);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection<? super E> c) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            int n = this.backing.drainTo(c);
            return n;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection<? super E> c, int maxElements) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            int n = this.backing.drainTo(c, maxElements);
            return n;
        }
        finally {
            l.unlock();
        }
    }

    public E remove() {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            Object e = this.backing.remove();
            return e;
        }
        finally {
            l.unlock();
        }
    }

    public E poll() {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            Object e = this.backing.poll();
            return e;
        }
        finally {
            l.unlock();
        }
    }

    public E element() {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            Object e = this.backing.element();
            return e;
        }
        finally {
            l.unlock();
        }
    }

    public E peek() {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            Object e = this.backing.peek();
            return e;
        }
        finally {
            l.unlock();
        }
    }

    public int size() {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            int n = this.backing.size();
            return n;
        }
        finally {
            l.unlock();
        }
    }

    public boolean isEmpty() {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            boolean bl = this.backing.isEmpty();
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    public Iterator<E> iterator() {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            LockedIterator lockedIterator = new LockedIterator((ReadWriteLock)this.lock, this.backing.iterator());
            return lockedIterator;
        }
        finally {
            l.unlock();
        }
    }

    public Object[] toArray() {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            Object[] objectArray = this.backing.toArray();
            return objectArray;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T[] toArray(T[] a) {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            T[] TArray = this.backing.toArray(a);
            return TArray;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection<?> c) {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            boolean bl = this.backing.containsAll(c);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection<? extends E> c) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            boolean bl = this.backing.addAll(c);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection<?> c) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            boolean bl = this.backing.removeAll(c);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection<?> c) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            boolean bl = this.backing.retainAll(c);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    public void clear() {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            this.backing.clear();
        }
        finally {
            l.unlock();
        }
    }

    public ToolkitReadWriteLock getReadWriteLock() {
        return this.lock;
    }
}

