/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.upgradability.interaction;

import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.terracotta.toolkit.Toolkit;
import org.terracotta.toolkit.ToolkitFeatureType;
import org.terracotta.toolkit.ToolkitFeatureTypeInternal;
import org.terracotta.toolkit.ToolkitInstantiationException;
import org.terracotta.toolkit.api.ToolkitFactoryService;
import org.terracotta.toolkit.internal.ToolkitInternal;
import org.terracotta.toolkit.internal.concurrent.locks.ToolkitLockTypeInternal;
import org.terracotta.upgradability.interaction.localtoolkit.LocalToolkit;

public class MockToolkitFactoryService
implements ToolkitFactoryService {
    private static final ConcurrentMap<ToolkitIdentifier, Toolkit> mocks = new ConcurrentHashMap<ToolkitIdentifier, Toolkit>();

    public static ToolkitInternal mockToolkitFor(String url) {
        ToolkitInternal spy = (ToolkitInternal)Mockito.spy((Object)new LocalToolkit());
        MockToolkitFactoryService.registerMock("terracotta", "//" + url, (Toolkit)spy);
        MockToolkitFactoryService.registerMock("nonstop-terracotta", "//" + url, (Toolkit)spy);
        return spy;
    }

    private static void registerMock(String type, String subname, Toolkit mock) {
        if (mocks.putIfAbsent(new ToolkitIdentifier(type, subname), mock) != null) {
            throw new IllegalStateException("Toolkit already registered");
        }
    }

    public static void allowNonPersistentInteractions(ToolkitInternal mock) {
        ((ToolkitInternal)Mockito.verify((Object)mock, (VerificationMode)Mockito.atLeast((int)0))).getClusterInfo();
        ((ToolkitInternal)Mockito.verify((Object)mock, (VerificationMode)Mockito.atLeast((int)0))).getLock(Mockito.anyString(), (ToolkitLockTypeInternal)Mockito.any(ToolkitLockTypeInternal.class));
        ((ToolkitInternal)Mockito.verify((Object)mock, (VerificationMode)Mockito.atLeast((int)0))).getLock(Mockito.anyString());
        ((ToolkitInternal)Mockito.verify((Object)mock, (VerificationMode)Mockito.atLeast((int)0))).getReadWriteLock(Mockito.anyString());
        ((ToolkitInternal)Mockito.verify((Object)mock, (VerificationMode)Mockito.atLeast((int)0))).getFeature((ToolkitFeatureTypeInternal)Mockito.any(ToolkitFeatureTypeInternal.class));
        ((ToolkitInternal)Mockito.verify((Object)mock, (VerificationMode)Mockito.atLeast((int)0))).getFeature((ToolkitFeatureType)Mockito.any(ToolkitFeatureType.class));
        ((ToolkitInternal)Mockito.verify((Object)mock, (VerificationMode)Mockito.atLeast((int)0))).getLogger(Mockito.anyString());
        ((ToolkitInternal)Mockito.verify((Object)mock, (VerificationMode)Mockito.atLeast((int)0))).getNotifier(Mockito.anyString(), (Class)Mockito.any(Class.class));
        ((ToolkitInternal)Mockito.verify((Object)mock, (VerificationMode)Mockito.atLeast((int)0))).getClientUUID();
        ((ToolkitInternal)Mockito.verify((Object)mock, (VerificationMode)Mockito.atLeast((int)0))).registerBeforeShutdownHook((Runnable)Mockito.any(Runnable.class));
    }

    public boolean canHandleToolkitType(String type, String subname) {
        return true;
    }

    public Toolkit createToolkit(String type, String subname, Properties properties) throws ToolkitInstantiationException {
        return (Toolkit)mocks.get(new ToolkitIdentifier(type, subname));
    }

    private static class ToolkitIdentifier {
        private final String type;
        private final String subname;

        public ToolkitIdentifier(String type, String subname) {
            this.type = type;
            this.subname = subname;
        }

        public int hashCode() {
            return this.type.hashCode() ^ this.subname.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ToolkitIdentifier) {
                ToolkitIdentifier other = (ToolkitIdentifier)obj;
                return this.type.equals(other.type) && this.subname.equals(other.subname);
            }
            return false;
        }
    }
}

