/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.terracotta.upgradability.interaction.localtoolkit.internal;

import java.util.Properties;
import org.terracotta.toolkit.internal.ToolkitProperties;

import static java.lang.Boolean.FALSE;

/**
 *
 * @author cdennis
 */
public class LocalProperties implements ToolkitProperties {

  private final Properties backing = new Properties();
  
  public LocalProperties() {
    backing.put("session.invalidator.sleep", "300");
  }

  public Integer getInteger(String key) {
    return getInteger(key, null);
  }

  public Integer getInteger(String key, Integer defaultValue) {
    String v = getProperty(key);
    if (v == null) {
      return defaultValue;
    } else {
      return Integer.decode(v);
    }
  }

  public Long getLong(String key) {
    return getLong(key, null);
  }

  public Long getLong(String key, Long defaultValue) {
    String v = getProperty(key);
    if (v == null) {
      return defaultValue;
    } else {
      return Long.decode(v);
    }
  }

  public Boolean getBoolean(String key) {
    return getBoolean(key, FALSE);
  }

  public Boolean getBoolean(String key, Boolean defaultValue) {
    String v = getProperty(key);
    if (v == null) {
      return defaultValue;
    } else {
      return Boolean.parseBoolean(v);
    }
  }

  public String getProperty(String key) {
    return backing.getProperty(key);
  }

  public String getProperty(String key, String defaultValue) {
    return backing.getProperty(key, defaultValue);
  }

  public void setProperty(String key, String value) throws NullPointerException {
    backing.setProperty(key, value);
  }
}
