/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.terracotta.upgradability.interaction.localtoolkit.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.terracotta.toolkit.internal.ToolkitLogger;
import org.terracotta.upgradability.interaction.localtoolkit.object.LocalToolkitObject;

import static java.util.logging.Logger.getLogger;

/**
 *
 * @author cdennis
 */
public class LocalLogger extends LocalToolkitObject implements ToolkitLogger {
  
  private final Logger backing;
  
  public LocalLogger(String name) {
    super(name);
    backing = getLogger(LocalLogger.class.getName() + "." + name);
  }

  public void debug(Object message) {
    backing.log(Level.FINE, message.toString());
  }

  public void debug(Object message, Throwable t) {
    backing.log(Level.FINE, message.toString(), t);
  }

  public void info(Object message) {
    backing.log(Level.INFO, message.toString());
  }

  public void info(Object message, Throwable t) {
    backing.log(Level.INFO, message.toString(), t);
  }

  public void warn(Object message) {
    backing.log(Level.WARNING, message.toString());
  }

  public void warn(Object message, Throwable t) {
    backing.log(Level.WARNING, message.toString(), t);
  }

  public void error(Object message) {
    backing.log(Level.SEVERE, message.toString());
  }

  public void error(Object message, Throwable t) {
    backing.log(Level.SEVERE, message.toString(), t);
  }

  public void fatal(Object message) {
    backing.log(Level.SEVERE, message.toString());
  }

  public void fatal(Object message, Throwable t) {
    backing.log(Level.SEVERE, message.toString(), t);
  }

  public boolean isDebugEnabled() {
    return backing.isLoggable(Level.FINE);
  }

  public boolean isInfoEnabled() {
    return backing.isLoggable(Level.INFO);
  }
  
}
