/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.terracotta.upgradability.interaction.localtoolkit.feature;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.terracotta.toolkit.ToolkitObjectType;
import org.terracotta.toolkit.feature.NonStopFeature;
import org.terracotta.toolkit.nonstop.NonStopConfiguration;
import org.terracotta.toolkit.nonstop.NonStopConfigurationRegistry;

/**
 *
 * @author cdennis
 */
public class LocalNonStopFeature implements NonStopFeature {

  private final NonStopConfigurationRegistry configRegistry = new LocalConfigRegistry();
  
  public LocalNonStopFeature() {
  }

  public void start(NonStopConfiguration nonStopConfig) {
    //no-op
  }

  public void finish() {
    //no-op
  }

  public boolean isTimedOut() {
    return false;
  }

  public NonStopConfigurationRegistry getNonStopConfigurationRegistry() {
    return configRegistry;
  }

  public boolean isEnabled() {
    throw new UnsupportedOperationException();
  }
  
  static class LocalConfigRegistry implements NonStopConfigurationRegistry {

    private final Map<Object, NonStopConfiguration> configs = new ConcurrentHashMap<Object, NonStopConfiguration>();

    public void registerForType(NonStopConfiguration config, ToolkitObjectType... types) {
      for (ToolkitObjectType type : types) {
        configs.put(type, config);
      }
    }

    public void registerForInstance(NonStopConfiguration config, String toolkitTypeName, ToolkitObjectType type) {
      configs.put(new InstanceKey(type, toolkitTypeName), config);
    }

    public void registerForTypeMethod(NonStopConfiguration config, String methodName, ToolkitObjectType type) {
      //no-op
    }

    public void registerForInstanceMethod(NonStopConfiguration config, String methodName, String toolkitTypeName, ToolkitObjectType type) {
      //no-op
    }

    public void registerTimeoutForSearch(long timeout, String instanceName, ToolkitObjectType objectType) {
      //no-op
    }

    public NonStopConfiguration getConfigForType(ToolkitObjectType type) {
      throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    public NonStopConfiguration getConfigForInstance(String toolkitTypeName, ToolkitObjectType type) {
      throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    public NonStopConfiguration getConfigForTypeMethod(String methodName, ToolkitObjectType type) {
      throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    public NonStopConfiguration getConfigForInstanceMethod(String methodName, String toolkitTypeName, ToolkitObjectType type) {
      throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    public long getTimeoutForSearch(String instanceName, ToolkitObjectType objectType) {
      throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    public NonStopConfiguration deregisterForType(ToolkitObjectType type) {
      return configs.remove(type);
    }

    public NonStopConfiguration deregisterForInstance(String toolkitTypeName, ToolkitObjectType type) {
      return configs.remove(new InstanceKey(type, toolkitTypeName));
    }

    public NonStopConfiguration deregisterForTypeMethod(String methodName, ToolkitObjectType type) {
      throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    public NonStopConfiguration deregisterForInstanceMethod(String methodName, String toolkitTypeName, ToolkitObjectType type) {
      throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    public long deregisterTimeoutForSearch(String instanceName, ToolkitObjectType objectType) {
      throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
  }
  
  static class InstanceKey {
    
    private final ToolkitObjectType type;
    private final String name;
    
    InstanceKey(ToolkitObjectType type, String name) {
      this.type = type;
      this.name = name;
    }

    @Override
    public int hashCode() {
      return type.hashCode() ^ name.hashCode();
    }
    
    @Override
    public boolean equals(Object o) {
      if (o instanceof InstanceKey) {
        InstanceKey ok = (InstanceKey) o;
        return type.equals(ok.type) && name.equals(ok.name);
      } else {
        return false;
      }
    }
  }
}
