/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.terracotta.upgradability.interaction.localtoolkit.events;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

import org.terracotta.toolkit.events.ToolkitNotificationListener;
import org.terracotta.toolkit.events.ToolkitNotifier;
import org.terracotta.upgradability.interaction.localtoolkit.object.LocalDestroyableToolkitObject;

/**
 *
 * @author cdennis
 */
public class LocalNotifier<E> extends LocalDestroyableToolkitObject implements ToolkitNotifier<E> {

  private final List<ToolkitNotificationListener<E>> listeners = new CopyOnWriteArrayList<ToolkitNotificationListener<E>>();
  
  public LocalNotifier(String name) {
    super(name);
  }

  public void addNotificationListener(ToolkitNotificationListener<E> listener) {
    listeners.add(listener);
  }

  public void removeNotificationListener(ToolkitNotificationListener<E> listener) {
    listeners.remove(listener);
  }

  public void notifyListeners(E msg) {
    //no-op
  }

  public List<ToolkitNotificationListener<E>> getNotificationListeners() {
    return Collections.unmodifiableList(listeners);
  }
}
