/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.terracotta.upgradability.interaction.localtoolkit.concurrent.locks;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

import org.terracotta.toolkit.concurrent.locks.ToolkitLock;
import org.terracotta.toolkit.concurrent.locks.ToolkitLockType;
import org.terracotta.toolkit.concurrent.locks.ToolkitReadWriteLock;

import static org.terracotta.toolkit.concurrent.locks.ToolkitLockType.READ;
import static org.terracotta.toolkit.concurrent.locks.ToolkitLockType.WRITE;

/**
 *
 * @author cdennis
 */
public abstract class LocalReadWriteLock implements ToolkitReadWriteLock {

  private final ReentrantReadWriteLock rwLock;
  private final ToolkitLock writeLock;
  private final ToolkitLock readLock;

  public LocalReadWriteLock() {
    this.rwLock = new ReentrantReadWriteLock();
    this.writeLock = new WriteLock(rwLock.writeLock(), WRITE);
    this.readLock = new ReadLock(rwLock.readLock(), READ);
  }

  public ToolkitLock readLock() {
    return readLock;
  }

  public ToolkitLock writeLock() {
    return writeLock;
  }

  class ReadLock extends LocalLock {

    public ReadLock(Lock lock, ToolkitLockType type) {
      super(lock, type);
    }

    public String getName() {
      return LocalReadWriteLock.this.getName();
    }

    public boolean isHeldByCurrentThread() {
      throw new UnsupportedOperationException();
    }
  }

  class WriteLock extends LocalLock {

    public WriteLock(Lock lock, ToolkitLockType type) {
      super(lock, type);
    }

    public String getName() {
      return LocalReadWriteLock.this.getName();
    }

    @Override
    public boolean isHeldByCurrentThread() {
      return rwLock.isWriteLockedByCurrentThread();
    }
    
  }
}
