/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.terracotta.upgradability.interaction.localtoolkit.concurrent.locks;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

import org.terracotta.toolkit.concurrent.locks.ToolkitLock;
import org.terracotta.toolkit.concurrent.locks.ToolkitLockType;

/**
 *
 * @author cdennis
 */
public abstract class LocalLock implements ToolkitLock {

  private final Lock lock;
  private final ToolkitLockType type;
  private final Condition theCondition;
  
  public LocalLock(Lock lock, ToolkitLockType type) {
    this.lock = lock;
    this.type = type;
    Condition singleCondition;
    try {
      singleCondition = lock.newCondition();
    } catch (UnsupportedOperationException e) {
      singleCondition = null;
    }
    theCondition = singleCondition;
  }

  public Condition newCondition() throws UnsupportedOperationException {
    return lock.newCondition();
  }

  public Condition getCondition() {
    if (theCondition == null) {
      throw new UnsupportedOperationException();
    } else {
      return theCondition;
    }
  }

  public ToolkitLockType getLockType() {
    return type;
  }

  public void lock() {
    lock.lock();
  }

  public void lockInterruptibly() throws InterruptedException {
    lock.lockInterruptibly();
  }

  public boolean tryLock() {
    return lock.tryLock();
  }

  public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
    return lock.tryLock(time, unit);
  }

  public void unlock() {
    lock.unlock();
  }
}
