/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.terracotta.upgradability.interaction.localtoolkit.collections;

import java.util.ListIterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

/**
 *
 * @author cdennis
 */
public class LockedListIterator<E> extends LockedIterator<E> implements ListIterator<E> {

  public LockedListIterator(ReadWriteLock lock, ListIterator<E> delegate) {
    super(lock, delegate);
  }

  
  public boolean hasPrevious() {
    Lock l = lock.readLock();
    l.lock();
    try {
      return ((ListIterator<E>) delegate).hasPrevious();
    } finally {
      l.unlock();
    }
  }

  public E previous() {
    Lock l = lock.readLock();
    l.lock();
    try {
      return ((ListIterator<E>) delegate).previous();
    } finally {
      l.unlock();
    }
  }

  public int nextIndex() {
    Lock l = lock.readLock();
    l.lock();
    try {
      return ((ListIterator<E>) delegate).nextIndex();
    } finally {
      l.unlock();
    }
  }

  public int previousIndex() {
    Lock l = lock.readLock();
    l.lock();
    try {
      return ((ListIterator<E>) delegate).previousIndex();
    } finally {
      l.unlock();
    }
  }

  public void set(E e) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      ((ListIterator<E>) delegate).set(e);
    } finally {
      l.unlock();
    }
  }

  public void add(E e) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      ((ListIterator<E>) delegate).add(e);
    } finally {
      l.unlock();
    }
  }
}
