/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.terracotta.upgradability.interaction.localtoolkit.collections;

import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

/**
 *
 * @author cdennis
 */
public class LockedIterator<E> implements Iterator<E> {

  protected final Iterator<E> delegate;
  protected final ReadWriteLock lock;

  public LockedIterator(ReadWriteLock lock, Iterator<E> delegate) {
    this.delegate = delegate;
    this.lock = lock;
  }
  
  public boolean hasNext() {
    Lock l = lock.readLock();
    l.lock();
    try {
      return delegate.hasNext();
    } finally {
      l.unlock();
    }
  }

  public E next() {
    Lock l = lock.readLock();
    l.lock();
    try {
      return delegate.next();
    } finally {
      l.unlock();
    }
  }

  public void remove() {
    Lock l = lock.readLock();
    l.lock();
    try {
      delegate.remove();
    } finally {
      l.unlock();
    }
  }
  
}
