/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.terracotta.upgradability.interaction.localtoolkit.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

/**
 *
 * @author cdennis
 */
public class LockedCollection<E> implements Collection<E> {

  private final Collection<E> delegate;
  private final ReadWriteLock lock;

  public LockedCollection(ReadWriteLock lock, Collection<E> delegate) {
    this.delegate = delegate;
    this.lock = lock;
  }
  
  public int size() {
    Lock l = lock.readLock();
    l.lock();
    try {
      return delegate.size();
    } finally {
      l.unlock();
    }
  }

  public boolean isEmpty() {
    Lock l = lock.readLock();
    l.lock();
    try {
      return delegate.isEmpty();
    } finally {
      l.unlock();
    }
  }

  public boolean contains(Object o) {
    Lock l = lock.readLock();
    l.lock();
    try {
      return delegate.contains(o);
    } finally {
      l.unlock();
    }
  }

  public Iterator<E> iterator() {
    Lock l = lock.readLock();
    l.lock();
    try {
      return new LockedIterator<E>(lock, delegate.iterator());
    } finally {
      l.unlock();
    }
  }

  public Object[] toArray() {
    Lock l = lock.readLock();
    l.lock();
    try {
      return delegate.toArray();
    } finally {
      l.unlock();
    }
  }

  public <T> T[] toArray(T[] a) {
    Lock l = lock.readLock();
    l.lock();
    try {
      return delegate.toArray(a);
    } finally {
      l.unlock();
    }
  }

  public boolean add(E e) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      return delegate.add(e);
    } finally {
      l.unlock();
    }
  }

  public boolean remove(Object o) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      return delegate.remove(o);
    } finally {
      l.unlock();
    }
  }

  public boolean containsAll(Collection<?> c) {
    Lock l = lock.readLock();
    l.lock();
    try {
      return delegate.containsAll(c);
    } finally {
      l.unlock();
    }
  }

  public boolean addAll(Collection<? extends E> c) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      return delegate.addAll(c);
    } finally {
      l.unlock();
    }
  }

  public boolean removeAll(Collection<?> c) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      return delegate.removeAll(c);
    } finally {
      l.unlock();
    }
  }

  public boolean retainAll(Collection<?> c) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      return delegate.retainAll(c);
    } finally {
      l.unlock();
    }
  }

  public void clear() {
    Lock l = lock.writeLock();
    l.lock();
    try {
      delegate.clear();
    } finally {
      l.unlock();
    }
  }
}
