/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.terracotta.upgradability.interaction.localtoolkit.collections;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import org.terracotta.toolkit.concurrent.locks.ToolkitReadWriteLock;
import org.terracotta.toolkit.config.Configuration;
import org.terracotta.toolkit.search.QueryBuilder;
import org.terracotta.toolkit.search.attribute.ToolkitAttributeExtractor;
import org.terracotta.toolkit.store.ToolkitStore;
import org.terracotta.upgradability.interaction.localtoolkit.object.LocalDestroyableToolkitObject;

/**
 *
 * @author cdennis
 */
public class LocalStore<K, V> extends LocalDestroyableToolkitObject implements ToolkitStore<K, V> {

  private final ConcurrentMap<K, V> map = new ConcurrentHashMap<K, V>();
  
  public LocalStore(String name, Configuration config, Class<V> valueType) {
    super(name);
  }

  @Override
  public boolean containsValue(Object o) {
    return map.containsValue(o);
  }

  @Override
  public void removeNoReturn(Object o) {
    map.remove(o);
  }

  @Override
  public void putNoReturn(K k, V v) {
    map.put(k, v);
  }

  @Override
  public Map<K, V> getAll(Collection<? extends K> clctn) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  @Override
  public Configuration getConfiguration() {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  @Override
  public void setConfigField(String string, Serializable srlzbl) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  @Override
  public ToolkitReadWriteLock createLockForKey(K k) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  @Override
  public V putIfAbsent(K k, V v) {
    return map.putIfAbsent(k, v);
  }

  @Override
  public boolean remove(Object k, Object v) {
    return map.remove(k, v);
  }

  @Override
  public boolean replace(K key, V oldValue, V newValue) {
    return map.replace(key, oldValue, newValue);
  }

  @Override
  public V replace(K k, V v) {
    return map.replace(k, v);
  }

  @Override
  public int size() {
    return map.size();
  }

  @Override
  public boolean isEmpty() {
    return map.isEmpty();
 }

  @Override
  public boolean containsKey(Object o) {
    return map.containsKey(o);
  }

  @Override
  public V get(Object o) {
    return map.get(o);
  }

  @Override
  public V put(K k, V v) {
    return map.put(k, v);
  }

  @Override
  public V remove(Object o) {
    return map.remove(o);
  }

  @Override
  public void putAll(Map<? extends K, ? extends V> entries) {
    map.putAll(entries);
  }

  @Override
  public void clear() {
    map.clear();
  }

  @Override
  public Set<K> keySet() {
    return map.keySet();
  }

  @Override
  public Collection<V> values() {
    return map.values();
  }

  @Override
  public Set<Entry<K, V>> entrySet() {
    return map.entrySet();
  }

  @Override
  public void setAttributeExtractor(ToolkitAttributeExtractor<K, V> tae) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  @Override
  public QueryBuilder createQueryBuilder() {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public boolean isBulkLoadEnabled() {
    return false;
  }

  public boolean isNodeBulkLoadEnabled() {
    return false;
  }

  public void setNodeBulkLoadEnabled(boolean bln) {
    throw new UnsupportedOperationException("Not supported yet.");
  }

  public void waitUntilBulkLoadComplete() throws InterruptedException {
    //no-op
  }
  
}
