/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.terracotta.upgradability.interaction.localtoolkit.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.terracotta.toolkit.collections.ToolkitSet;
import org.terracotta.toolkit.concurrent.locks.ToolkitReadWriteLock;
import org.terracotta.upgradability.interaction.localtoolkit.object.LocalDestroyableToolkitObject;

/**
 *
 * @author cdennis
 */
public class LocalSet<E> extends LocalDestroyableToolkitObject implements ToolkitSet<E> {

  private final Set<E> set = Collections.newSetFromMap(new ConcurrentHashMap<E, Boolean>());
  
  public LocalSet(String name, Class<E> elementType) {
    super(name);
  }
  
  @Override
  public int size() {
    return set.size();
  }

  @Override
  public boolean isEmpty() {
    return set.isEmpty();
  }

  @Override
  public boolean contains(Object o) {
    return set.contains(o);
  }

  @Override
  public Iterator<E> iterator() {
    return set.iterator();
  }

  @Override
  public Object[] toArray() {
    return set.toArray();
  }

  @Override
  public <T> T[] toArray(T[] ts) {
    return set.toArray(ts);
  }

  @Override
  public boolean add(E e) {
    return set.add(e);
  }

  @Override
  public boolean remove(Object o) {
    return set.remove(o);
  }

  @Override
  public boolean containsAll(Collection<?> clctn) {
    return set.containsAll(clctn);
  }

  @Override
  public boolean addAll(Collection<? extends E> clctn) {
    return set.addAll(clctn);
  }

  @Override
  public boolean retainAll(Collection<?> clctn) {
    return set.retainAll(clctn);
  }

  @Override
  public boolean removeAll(Collection<?> clctn) {
    return set.removeAll(clctn);
  }

  @Override
  public void clear() {
    set.clear();
  }

  @Override
  public ToolkitReadWriteLock getReadWriteLock() {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }
}
