/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.terracotta.upgradability.interaction.localtoolkit.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.terracotta.toolkit.collections.ToolkitMap;
import org.terracotta.toolkit.concurrent.locks.ToolkitReadWriteLock;
import org.terracotta.upgradability.interaction.localtoolkit.object.LocalDestroyableToolkitObject;
import org.terracotta.upgradability.interaction.localtoolkit.concurrent.locks.AnonymousLocalReadWriteLock;

/**
 *
 * @author cdennis
 */
public class LocalMap<K, V> extends LocalDestroyableToolkitObject implements ToolkitMap<K, V>{

  private final ToolkitReadWriteLock lock = new AnonymousLocalReadWriteLock();
  private final Map<K, V> backing = new HashMap<K, V>();
  
  public LocalMap(String name) {
    super(name);
  }

  public V putIfAbsent(K key, V value) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      if (backing.containsKey(key)) {
        return backing.get(key);
      } else {
        backing.put(key, value);
        return null;
      }
    } finally {
      l.unlock();
    }
  }

  public boolean remove(Object key, Object value) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public boolean replace(K key, V oldValue, V newValue) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public V replace(K key, V value) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public int size() {
    Lock l = lock.readLock();
    l.lock();
    try {
      return backing.size();
    } finally {
      l.unlock();
    }
  }

  public boolean isEmpty() {
    Lock l = lock.readLock();
    l.lock();
    try {
      return backing.isEmpty();
    } finally {
      l.unlock();
    }
  }

  public boolean containsKey(Object key) {
    Lock l = lock.readLock();
    l.lock();
    try {
      return backing.containsKey(key);
    } finally {
      l.unlock();
    }
  }

  public boolean containsValue(Object value) {
    Lock l = lock.readLock();
    l.lock();
    try {
      return backing.containsValue(value);
    } finally {
      l.unlock();
    }
  }

  public V get(Object key) {
    Lock l = lock.readLock();
    l.lock();
    try {
      return backing.get(key);
    } finally {
      l.unlock();
    }
  }

  public V put(K key, V value) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      return backing.put(key, value);
    } finally {
      l.unlock();
    }
  }

  public V remove(Object key) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      return backing.remove(key);
    } finally {
      l.unlock();
    }
  }

  public void putAll(Map<? extends K, ? extends V> m) {
    for (Map.Entry<? extends K, ? extends V> e : m.entrySet()) {
      put(e.getKey(), e.getValue());
    }
  }

  public void clear() {
    Lock l = lock.writeLock();
    l.lock();
    try {
      backing.clear();
    } finally {
      l.unlock();
    }
  }

  public Set<K> keySet() {
    return new LockedSet<K>(lock, backing.keySet());
  }

  public Collection<V> values() {
    return new LockedCollection<V>(lock, backing.values());
  }

  public Set<Entry<K, V>> entrySet() {
    return new LockedSet<Entry<K, V>>(lock, backing.entrySet());
  }

  public ToolkitReadWriteLock getReadWriteLock() {
    return lock;
  }
}
