/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.terracotta.upgradability.interaction.localtoolkit.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.Lock;
import org.terracotta.toolkit.concurrent.locks.ToolkitReadWriteLock;
import org.terracotta.toolkit.internal.collections.ToolkitListInternal;
import org.terracotta.upgradability.interaction.localtoolkit.object.LocalDestroyableToolkitObject;
import org.terracotta.upgradability.interaction.localtoolkit.concurrent.locks.AnonymousLocalReadWriteLock;

/**
 *
 * @author cdennis
 */
public class LocalList<E> extends LocalDestroyableToolkitObject implements ToolkitListInternal<E>{

  private final ToolkitReadWriteLock lock;
  private final List<E> backing;

  public LocalList(String name) {
    this(name, new AnonymousLocalReadWriteLock(), new ArrayList<E>());
  }
  
  private LocalList(String name, ToolkitReadWriteLock lock, List<E> backing) {
    super(name);
    this.lock = lock;
    this.backing = backing;
  }
  
  public int size() {
    Lock l = lock.readLock();
    l.lock();
    try {
      return backing.size();
    } finally {
      l.unlock();
    }
  }

  public boolean isEmpty() {
    Lock l = lock.readLock();
    l.lock();
    try {
      return backing.isEmpty();
    } finally {
      l.unlock();
    }
  }

  public boolean contains(Object o) {
    Lock l = lock.readLock();
    l.lock();
    try {
      return backing.contains(o);
    } finally {
      l.unlock();
    }
  }

  public Iterator<E> iterator() {
    return new LockedIterator<E>(lock, backing.iterator());
  }

  public Object[] toArray() {
    Lock l = lock.readLock();
    l.lock();
    try {
      return backing.toArray();
    } finally {
      l.unlock();
    }
  }

  public <T> T[] toArray(T[] a) {
    Lock l = lock.readLock();
    l.lock();
    try {
      return backing.toArray(a);
    } finally {
      l.unlock();
    }
  }

  public boolean add(E e) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      return backing.add(e);
    } finally {
      l.unlock();
    }
  }

  public boolean remove(Object o) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      return backing.remove(o);
    } finally {
      l.unlock();
    }
  }

  public boolean containsAll(Collection<?> c) {
    Lock l = lock.readLock();
    l.lock();
    try {
      return backing.containsAll(c);
    } finally {
      l.unlock();
    }
  }

  public boolean addAll(Collection<? extends E> c) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      return backing.addAll(c);
    } finally {
      l.unlock();
    }
  }

  public boolean addAll(int index, Collection<? extends E> c) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      return backing.addAll(index, c);
    } finally {
      l.unlock();
    }
  }

  public boolean removeAll(Collection<?> c) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      return backing.removeAll(c);
    } finally {
      l.unlock();
    }
  }

  public boolean retainAll(Collection<?> c) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      return backing.retainAll(c);
    } finally {
      l.unlock();
    }
  }

  public void clear() {
    Lock l = lock.writeLock();
    l.lock();
    try {
      backing.clear();
    } finally {
      l.unlock();
    }
  }

  public E get(int index) {
    Lock l = lock.readLock();
    l.lock();
    try {
      return backing.get(index);
    } finally {
      l.unlock();
    }
  }

  public E set(int index, E element) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      return backing.set(index, element);
    } finally {
      l.unlock();
    }
  }

  public void add(int index, E element) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      backing.add(index, element);
    } finally {
      l.unlock();
    }
  }

  public E remove(int index) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      return backing.remove(index);
    } finally {
      l.unlock();
    }
  }

  public int indexOf(Object o) {
    Lock l = lock.readLock();
    l.lock();
    try {
      return backing.indexOf(o);
    } finally {
      l.unlock();
    }
  }

  public int lastIndexOf(Object o) {
    Lock l = lock.readLock();
    l.lock();
    try {
      return backing.lastIndexOf(o);
    } finally {
      l.unlock();
    }
  }

  public ListIterator<E> listIterator() {
    return new LockedListIterator(lock, backing.listIterator());
  }

  public ListIterator<E> listIterator(int index) {
    return new LockedListIterator(lock, backing.listIterator(index));
  }

  public List<E> subList(int fromIndex, int toIndex) {
    return new LocalList<E>(getName(), lock, backing.subList(fromIndex, toIndex));
  }

  public ToolkitReadWriteLock getReadWriteLock() {
    return lock;
  }

  public boolean unlockedAdd(E e) {
    return add(e);
  }
}
