/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.terracotta.upgradability.interaction.localtoolkit.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.terracotta.toolkit.collections.ToolkitBlockingQueue;
import org.terracotta.toolkit.concurrent.locks.ToolkitReadWriteLock;
import org.terracotta.upgradability.interaction.localtoolkit.concurrent.locks.AnonymousLocalReadWriteLock;
import org.terracotta.upgradability.interaction.localtoolkit.object.LocalDestroyableToolkitObject;

/**
 *
 * @author cdennis
 */
public class LocalBlockingQueue<E> extends LocalDestroyableToolkitObject implements ToolkitBlockingQueue<E> {

  private final ToolkitReadWriteLock lock = new AnonymousLocalReadWriteLock();
  private final BlockingQueue<E> backing;

  public LocalBlockingQueue(String name, Class<E> type) {
    super(name);
    this.backing = new LinkedBlockingQueue<E>();
  }
  
  public LocalBlockingQueue(String name, int capacity, Class<E> type) {
    super(name);
    this.backing = new LinkedBlockingDeque<E>(capacity);
  }
  
  public int getCapacity() {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public boolean add(E e) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      return backing.add(e);
    } finally {
      l.unlock();
    }
  }

  public boolean offer(E e) {
    Lock l = lock.writeLock();
    l.lock();
    try {
    return backing.offer(e);
    } finally {
      l.unlock();
    }
  }

  public void put(E e) throws InterruptedException {
    Lock l = lock.writeLock();
    l.lock();
    try {
    backing.put(e);
    } finally {
      l.unlock();
    }
  }

  public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
    Lock l = lock.writeLock();
    l.lock();
    try {
    return backing.offer(e, timeout, unit);
    } finally {
      l.unlock();
    }
  }

  public E take() throws InterruptedException {
    Lock l = lock.writeLock();
    l.lock();
    try {
    return backing.take();
    } finally {
      l.unlock();
    }
  }

  public E poll(long timeout, TimeUnit unit) throws InterruptedException {
    Lock l = lock.readLock();
    l.lock();
    try {
    return backing.poll(timeout, unit);
    } finally {
      l.unlock();
    }
  }

  public int remainingCapacity() {
    Lock l = lock.readLock();
    l.lock();
    try {
    return backing.remainingCapacity();
    } finally {
      l.unlock();
    }
  }

  public boolean remove(Object o) {
    Lock l = lock.writeLock();
    l.lock();
    try {
    return backing.remove(o);
    } finally {
      l.unlock();
    }
  }

  public boolean contains(Object o) {
    Lock l = lock.readLock();
    l.lock();
    try {
    return backing.contains(o);
    } finally {
      l.unlock();
    }
  }

  public int drainTo(Collection<? super E> c) {
    Lock l = lock.writeLock();
    l.lock();
    try {
    return backing.drainTo(c);
    } finally {
      l.unlock();
    }
  }

  public int drainTo(Collection<? super E> c, int maxElements) {
    Lock l = lock.writeLock();
    l.lock();
    try {
    return backing.drainTo(c, maxElements);
    } finally {
      l.unlock();
    }
  }

  public E remove() {
    Lock l = lock.writeLock();
    l.lock();
    try {
    return backing.remove();
    } finally {
      l.unlock();
    }
  }

  public E poll() {
    Lock l = lock.readLock();
    l.lock();
    try {
    return backing.poll();
    } finally {
      l.unlock();
    }
  }

  public E element() {
    Lock l = lock.readLock();
    l.lock();
    try {
    return backing.element();
    } finally {
      l.unlock();
    }
  }

  public E peek() {
    Lock l = lock.readLock();
    l.lock();
    try {
    return backing.peek();
    } finally {
      l.unlock();
    }
  }

  public int size() {
    Lock l = lock.readLock();
    l.lock();
    try {
    return backing.size();
    } finally {
      l.unlock();
    }
  }

  public boolean isEmpty() {
    Lock l = lock.readLock();
    l.lock();
    try {
    return backing.isEmpty();
    } finally {
      l.unlock();
    }
  }

  public Iterator<E> iterator() {
    Lock l = lock.readLock();
    l.lock();
    try {
    return new LockedIterator<E>(lock, backing.iterator());
    } finally {
      l.unlock();
    }
  }

  public Object[] toArray() {
    Lock l = lock.readLock();
    l.lock();
    try {
    return backing.toArray();
    } finally {
      l.unlock();
    }
  }

  public <T> T[] toArray(T[] a) {
    Lock l = lock.readLock();
    l.lock();
    try {
    return backing.toArray(a);
    } finally {
      l.unlock();
    }
  }

  public boolean containsAll(Collection<?> c) {
    Lock l = lock.readLock();
    l.lock();
    try {
    return backing.containsAll(c);
    } finally {
      l.unlock();
    }
  }

  public boolean addAll(Collection<? extends E> c) {
    Lock l = lock.writeLock();
    l.lock();
    try {
    return backing.addAll(c);
    } finally {
      l.unlock();
    }
  }

  public boolean removeAll(Collection<?> c) {
    Lock l = lock.writeLock();
    l.lock();
    try {
    return backing.removeAll(c);
    } finally {
      l.unlock();
    }
  }

  public boolean retainAll(Collection<?> c) {
    Lock l = lock.writeLock();
    l.lock();
    try {
    return backing.retainAll(c);
    } finally {
      l.unlock();
    }
  }

  public void clear() {
    Lock l = lock.writeLock();
    l.lock();
    try {
    backing.clear();
    } finally {
      l.unlock();
    }
  }

  public ToolkitReadWriteLock getReadWriteLock() {
    return lock;
  }
}
