/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.terracotta.upgradability.interaction.localtoolkit.cluster;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Set;
import org.terracotta.toolkit.cluster.ClusterInfo;
import org.terracotta.toolkit.cluster.ClusterListener;
import org.terracotta.toolkit.cluster.ClusterNode;

/**
 *
 * @author cdennis
 */
public class LocalClusterInfo implements ClusterInfo {

  private final ClusterNode localNode = new LocalClusterNode();
  
  @Override
  public void addClusterListener(ClusterListener cl) {
    //ignore - since cluster state will never change
  }

  @Override
  public void removeClusterListener(ClusterListener cl) {
    //ignore - since cluster state will never change
  }

  @Override
  public ClusterNode getCurrentNode() {
    return localNode;
  }

  @Override
  public boolean areOperationsEnabled() {
    return true;
  }

  @Override
  public Set<ClusterNode> getNodes() {
    return Collections.singleton(getCurrentNode());
  }

  private static class LocalClusterNode implements ClusterNode {

    public LocalClusterNode() {
    }

    @Override
    public String getId() {
      return "LocalClusterNode";
    }

    @Override
    public InetAddress getAddress() {
      try {
        return InetAddress.getLocalHost();
      } catch (UnknownHostException ex) {
        throw new RuntimeException(ex);
      }
    }
  }
  
}
