/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.terracotta.upgradability.interaction.localtoolkit.cache;

import org.terracotta.upgradability.interaction.localtoolkit.concurrent.locks.AnonymousLocalReadWriteLock;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.terracotta.toolkit.cache.ToolkitCacheListener;
import org.terracotta.toolkit.cluster.ClusterNode;
import org.terracotta.toolkit.concurrent.locks.ToolkitReadWriteLock;
import org.terracotta.toolkit.config.Configuration;
import org.terracotta.toolkit.internal.cache.ToolkitCacheInternal;
import org.terracotta.toolkit.internal.cache.ToolkitValueComparator;
import org.terracotta.toolkit.internal.cache.VersionUpdateListener;
import org.terracotta.toolkit.internal.cache.VersionedValue;
import org.terracotta.toolkit.search.QueryBuilder;
import org.terracotta.toolkit.search.attribute.ToolkitAttributeExtractor;
import org.terracotta.upgradability.interaction.localtoolkit.object.LocalDestroyableToolkitObject;
import org.terracotta.upgradability.interaction.localtoolkit.collections.LockedCollection;
import org.terracotta.upgradability.interaction.localtoolkit.collections.LockedSet;

/**
 *
 * @author cdennis
 */
public class LocalCache<K, V> extends LocalDestroyableToolkitObject implements ToolkitCacheInternal<K, V> {

  private final ToolkitReadWriteLock lock = new AnonymousLocalReadWriteLock();
  private final Map<K, V> backing = new HashMap<K, V>();
  private final Configuration config;
  
  public LocalCache(String name, Configuration config, Class<K> keyType, Class<V> valueType) {
    super(name);
    this.config = config;
  }
  
  public void removeNoReturn(Object key) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      backing.remove(key);
    } finally {
      l.unlock();
    }
  }

  public void putNoReturn(K key, V value) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      backing.put(key, value);
    } finally {
      l.unlock();
    }
  }

  public Map<K, V> getAll(Collection<? extends K> keys) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public Configuration getConfiguration() {
    return config;
  }

  public void setConfigField(String name, Serializable value) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public ToolkitReadWriteLock createLockForKey(K key) {
    return lock;
  }

  public V getQuiet(Object key) {
    Lock l = lock.readLock();
    l.lock();
    try {
      return backing.get(key);
    } finally {
      l.unlock();
    }
  }

  public Map<K, V> getAllQuiet(Collection<K> keys) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public void putNoReturn(K key, V value, long createTimeInSecs, int maxTTISeconds, int maxTTLSeconds) {
    putNoReturn(key, value);
  }

  public V putIfAbsent(K key, V value, long createTimeInSecs, int maxTTISeconds, int maxTTLSeconds) {
    return putIfAbsent(key, value);
  }

  public void addListener(ToolkitCacheListener<K> listener) {
    //no-op
  }

  public void removeListener(ToolkitCacheListener<K> listener) {
    //no-op
  }

  public V putIfAbsent(K key, V value) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      if (backing.containsKey(key)) {
        return backing.get(key);
      } else {
        backing.put(key, value);
        return null;
      }
    } finally {
      l.unlock();
    }
  }

  public boolean remove(Object key, Object value) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      if (backing.containsKey(key) && value.equals(backing.get(key))) {
        backing.remove(key);
        return true;
      } else {
        return false;
      }
    } finally {
      l.unlock();
    }
  }

  public boolean replace(K key, V oldValue, V newValue) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      if (backing.containsKey(key) && oldValue.equals(backing.get(key))) {
        backing.put(key, newValue);
        return true;
      } else {
        return false;
      }
    } finally {
      l.unlock();
    }
  }

  public V replace(K key, V value) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      if (backing.containsKey(key)) {
        return backing.put(key, value);
      } else {
        return null;
      }
    } finally {
      l.unlock();
    }
  }

  public int size() {
    Lock l = lock.readLock();
    l.lock();
    try {
      return backing.size();
    } finally {
      l.unlock();
    }
  }

  public boolean isEmpty() {
    Lock l = lock.readLock();
    l.lock();
    try {
      return backing.isEmpty();
    } finally {
      l.unlock();
    }
  }

  public boolean containsKey(Object key) {
    Lock l = lock.readLock();
    l.lock();
    try {
      return backing.containsKey(key);
    } finally {
      l.unlock();
    }
  }

  public boolean containsValue(Object value) {
    Lock l = lock.readLock();
    l.lock();
    try {
      return backing.containsValue(value);
    } finally {
      l.unlock();
    }
  }

  public V get(Object key) {
    Lock l = lock.readLock();
    l.lock();
    try {
      return backing.get(key);
    } finally {
      l.unlock();
    }
  }

  public V put(K key, V value) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      return backing.put(key, value);
    } finally {
      l.unlock();
    }
  }

  public V remove(Object key) {
    Lock l = lock.writeLock();
    l.lock();
    try {
      return backing.remove(key);
    } finally {
      l.unlock();
    }
  }

  public void putAll(Map<? extends K, ? extends V> m) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public void clear() {
    Lock l = lock.writeLock();
    l.lock();
    try {
      backing.clear();
    } finally {
      l.unlock();
    }
  }

  public Set<K> keySet() {
    Lock l = lock.readLock();
    l.lock();
    try {
      return new LockedSet<K>(lock, backing.keySet());
    } finally {
      l.unlock();
    }
  }

  public Collection<V> values() {
    Lock l = lock.readLock();
    l.lock();
    try {
      return new LockedCollection<V>(lock, backing.values());
    } finally {
      l.unlock();
    }
  }

  public Set<Entry<K, V>> entrySet() {
    Lock l = lock.readLock();
    l.lock();
    try {
      return new LockedSet<Entry<K, V>>(lock, backing.entrySet());
    } finally {
      l.unlock();
    }
  }

  public void setAttributeExtractor(ToolkitAttributeExtractor<K, V> attrExtractor) {
    //no-op
  }

  public QueryBuilder createQueryBuilder() {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public Map<Object, Set<ClusterNode>> getNodesWithKeys(Set portableKeys) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public void unlockedPutNoReturn(K k, V v, int createTime, int customTTI, int customTTL) {
    putNoReturn(k, v, createTime, createTime, createTime);
  }

  public void unlockedPutNoReturnVersioned(K k, V v, long version, int createTime, int customTTI, int customTTL) {
    putVersioned(k, v, version, createTime, customTTI, customTTL);
  }

  public void unlockedRemoveNoReturn(Object k) {
    removeNoReturn(k);
  }

  public void unlockedRemoveNoReturnVersioned(Object key, long version) {
    removeVersioned(key, version);
  }

  public V unlockedGet(Object k, boolean quiet) {
    return get(k);
  }

  public Map<K, V> unlockedGetAll(Collection<K> keys, boolean quiet) {
    if (quiet) {
      return getAllQuiet(keys);
    } else {
      return getAll(keys);
    }
  }

  public void clearLocalCache() {
    //no-op
  }

  public V unsafeLocalGet(Object key) {
    return get(key);
  }

  public boolean containsLocalKey(Object key) {
    return containsKey(key);
  }

  public int localSize() {
    return size();
  }

  public Set<K> localKeySet() {
    return keySet();
  }

  public long localOnHeapSizeInBytes() {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public long localOffHeapSizeInBytes() {
    return 0L;
  }

  public int localOnHeapSize() {
    return localSize();
  }

  public int localOffHeapSize() {
    return 0;
  }

  public boolean containsKeyLocalOnHeap(Object key) {
    return containsLocalKey(key);
  }

  public boolean containsKeyLocalOffHeap(Object key) {
    return false;
  }

  public V put(K key, V value, int createTimeInSecs, int customMaxTTISeconds, int customMaxTTLSeconds) {
    return put(key, value);
  }

  public void putVersioned(K key, V value, long version) {
    put(key, value);
  }

  public void putVersioned(K key, V value, long version, int createTimeInSecs, int customMaxTTISeconds, int customMaxTTLSeconds) {
    putVersioned(key, value, version);
  }

  public void disposeLocally() {
    //no-op
  }

  public void removeAll(Set<K> keys) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public void removeVersioned(Object key, long version) {
    removeNoReturn(key);
  }

  public void registerVersionUpdateListener(VersionUpdateListener listener) {
    throw new UnsupportedOperationException("Not supported yet.");
  }

  @Override
  public void unregisterVersionUpdateListener(final VersionUpdateListener listener) {
    throw new UnsupportedOperationException("Not supported yet.");
  }

  public void putIfAbsentVersioned(K k, V v, long l) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public void putIfAbsentVersioned(K k, V v, long l, int i, int i1, int i2) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public Set<K> keySetForSegment(int i) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public VersionedValue<V> getVersionedValue(Object o) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public void clearVersioned() {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public Map<K, VersionedValue<V>> getAllVersioned(Collection<K> ks) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public void quickClear() {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public int quickSize() {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public boolean remove(Object o, Object o1, ToolkitValueComparator<V> tvc) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public boolean replace(K k, V v, V v1, ToolkitValueComparator<V> tvc) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public boolean isBulkLoadEnabled() {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public boolean isNodeBulkLoadEnabled() {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public void setNodeBulkLoadEnabled(boolean bln) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  public void waitUntilBulkLoadComplete() throws InterruptedException {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }
}
