/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.terracotta.upgradability.interaction.localtoolkit;

import org.terracotta.toolkit.internal.feature.ManagementInternalFeature;
import org.terracotta.toolkit.internal.feature.NonStopInternalFeature;
import org.terracotta.upgradability.interaction.localtoolkit.atomic.LocalToolkitTransactionController;
import org.terracotta.upgradability.interaction.localtoolkit.internal.LocalProperties;
import org.terracotta.upgradability.interaction.localtoolkit.feature.LocalNonStopFeature;
import org.terracotta.upgradability.interaction.localtoolkit.internal.LocalLogger;
import org.terracotta.upgradability.interaction.localtoolkit.internal.feature.LocalLicenseFeature;
import org.terracotta.upgradability.interaction.localtoolkit.feature.LocalSearchFeature;
import org.terracotta.upgradability.interaction.localtoolkit.collections.LocalStore;
import org.terracotta.upgradability.interaction.localtoolkit.collections.LocalSortedSet;
import org.terracotta.upgradability.interaction.localtoolkit.collections.LocalSet;
import org.terracotta.upgradability.interaction.localtoolkit.events.LocalNotifier;
import org.terracotta.upgradability.interaction.localtoolkit.collections.LocalMap;
import org.terracotta.upgradability.interaction.localtoolkit.cluster.LocalClusterInfo;
import org.terracotta.upgradability.interaction.localtoolkit.collections.LocalBlockingQueue;
import org.terracotta.upgradability.interaction.localtoolkit.cache.LocalCache;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.terracotta.toolkit.ToolkitFeature;
import org.terracotta.toolkit.ToolkitFeatureType;
import org.terracotta.toolkit.ToolkitFeatureTypeInternal;
import org.terracotta.toolkit.atomic.ToolkitTransactionController;
import org.terracotta.toolkit.builder.ToolkitCacheConfigBuilder;
import org.terracotta.toolkit.builder.ToolkitStoreConfigBuilder;
import org.terracotta.toolkit.cache.ToolkitCache;
import org.terracotta.toolkit.cluster.ClusterInfo;
import org.terracotta.toolkit.collections.ToolkitBlockingQueue;
import org.terracotta.toolkit.collections.ToolkitList;
import org.terracotta.toolkit.collections.ToolkitMap;
import org.terracotta.toolkit.collections.ToolkitSet;
import org.terracotta.toolkit.collections.ToolkitSortedMap;
import org.terracotta.toolkit.collections.ToolkitSortedSet;
import org.terracotta.toolkit.concurrent.ToolkitBarrier;
import org.terracotta.toolkit.concurrent.atomic.ToolkitAtomicLong;
import org.terracotta.toolkit.concurrent.locks.ToolkitLock;
import org.terracotta.toolkit.concurrent.locks.ToolkitReadWriteLock;
import org.terracotta.toolkit.config.Configuration;
import org.terracotta.toolkit.events.ToolkitNotifier;
import org.terracotta.toolkit.feature.NonStopFeature;
import org.terracotta.toolkit.feature.SearchFeature;
import org.terracotta.toolkit.internal.ToolkitInternal;
import org.terracotta.toolkit.internal.ToolkitLogger;
import org.terracotta.toolkit.internal.ToolkitProperties;
import org.terracotta.toolkit.internal.concurrent.locks.ToolkitLockTypeInternal;
import org.terracotta.toolkit.internal.feature.LicenseFeature;
import org.terracotta.toolkit.monitoring.OperatorEventLevel;
import org.terracotta.toolkit.store.ToolkitStore;
import org.terracotta.upgradability.interaction.localtoolkit.collections.LocalList;
import org.terracotta.upgradability.interaction.localtoolkit.concurrent.locks.LocalConcurrentLock;
import org.terracotta.upgradability.interaction.localtoolkit.concurrent.locks.NamedLocalReadWriteLock;
import org.terracotta.upgradability.interaction.localtoolkit.internal.feature.LocalManagementInternalFeature;
import org.terracotta.upgradability.interaction.localtoolkit.internal.feature.LocalNonStopInternalFeature;

/**
 *
 * @author cdennis
 */
public class LocalToolkit implements ToolkitInternal {

  private final String clientUuid = UUID.randomUUID().toString();
  private final ClusterInfo clusterInfo = new LocalClusterInfo();
  private final ToolkitTransactionController transactionController = new LocalToolkitTransactionController();
  private final LicenseFeature license = new LocalLicenseFeature();
  private final ManagementInternalFeature management = new LocalManagementInternalFeature();
  private final NonStopFeature nonstop = new LocalNonStopFeature();
  private final NonStopInternalFeature nonstopInternal = new LocalNonStopInternalFeature();
  private final SearchFeature search = new LocalSearchFeature();
  private final ToolkitProperties properties = new LocalProperties();

  private final Collection<Runnable> shutdownHooks = new CopyOnWriteArrayList<Runnable>();

  private final ConcurrentMap<ToolkitObjectIdentifier, Object> objects = new ConcurrentHashMap<ToolkitObjectIdentifier, Object>();

  @Override
  public ToolkitLock getLock(final String name, final ToolkitLockTypeInternal tlti) {
    if (ToolkitLockTypeInternal.CONCURRENT.equals(tlti)) {
      return new LocalConcurrentLock(name);
    } else {
      ToolkitReadWriteLock lock = getReadWriteLock(name);
      switch (tlti) {
        case SYNCHRONOUS_WRITE:
        case WRITE:
          return lock.writeLock();
        case READ:
          return lock.readLock();
        default:
          throw new UnsupportedOperationException();
      }
    }
  }

  @Override
  public void registerBeforeShutdownHook(Runnable r) {
    shutdownHooks.add(r);
  }

  @Override
  public void waitUntilAllTransactionsComplete() {
    //no-op
  }

  @Override
  public ToolkitLogger getLogger(String string) {
    return new LocalLogger(string);
  }

  @Override
  public String getClientUUID() {
    return clientUuid;
  }

  @Override
  public ToolkitProperties getProperties() {
    return properties;
  }

  @Override
  public <T extends ToolkitFeature> T getFeature(ToolkitFeatureTypeInternal<T> tfti) {
    if (ToolkitFeatureTypeInternal.TRANSACTION.equals(tfti)) {
      return tfti.getFeatureClass().cast(transactionController);
    } else if (ToolkitFeatureTypeInternal.LICENSE.equals(tfti)) {
      return tfti.getFeatureClass().cast(license);
    } else if (ToolkitFeatureTypeInternal.MANAGEMENT.equals(tfti)) {
      return tfti.getFeatureClass().cast(management);
    } else if (ToolkitFeatureTypeInternal.NONSTOP.equals(tfti)) {
      return tfti.getFeatureClass().cast(nonstopInternal);
    } else {
      throw new UnsupportedOperationException("Feature: " + tfti + " not supported");
    }
  }

  @Override
  public <E> ToolkitList<E> getList(final String string, Class<E> type) {
    return getOrCreateToolkitObject(ToolkitList.class, string, new Callable() {

      public Object call() throws Exception {
        return new LocalList<E>(string);
      }
    });
  }

  @Override
  public <V> ToolkitStore<String, V> getStore(final String name, final Configuration config, final Class<V> type) {
    return getOrCreateToolkitObject(ToolkitStore.class, name, new Callable<ToolkitStore>() {

      public ToolkitStore<String, V> call() throws Exception {
        return new LocalStore<String, V>(name, config, type);
      }
    });
  }

  @Override
  public <V> ToolkitStore<String, V> getStore(String string, Class<V> type) {
    return getStore(string, new ToolkitStoreConfigBuilder().build(), type);
  }

  @Override
  public <K, V> ToolkitMap<K, V> getMap(final String name, Class<K> keyType, Class<V> valueType) {
    return getOrCreateToolkitObject(ToolkitMap.class, name, new Callable<ToolkitMap>() {

      public ToolkitMap call() throws Exception {
        return new LocalMap(name);
      }
    });
  }

  @Override
  public <K extends Comparable<? super K>, V> ToolkitSortedMap<K, V> getSortedMap(String string, Class<K> type, Class<V> type1) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  @Override
  public <E> ToolkitBlockingQueue<E> getBlockingQueue(final String name, final int capacity, final Class<E> type) {
    return getOrCreateToolkitObject(ToolkitBlockingQueue.class, name, new Callable<ToolkitBlockingQueue>() {
      public ToolkitBlockingQueue<E> call() throws Exception {
        return new LocalBlockingQueue<E>(name, capacity, type);
      }
    });
  }

  @Override
  public <E> ToolkitBlockingQueue<E> getBlockingQueue(final String name, final Class<E> type) {
    return getOrCreateToolkitObject(ToolkitBlockingQueue.class, name, new Callable<ToolkitBlockingQueue>() {
      public ToolkitBlockingQueue<E> call() throws Exception {
        return new LocalBlockingQueue<E>(name, type);
      }
    });
  }

  @Override
  public ClusterInfo getClusterInfo() {
    return clusterInfo;
  }

  @Override
  public ToolkitLock getLock(String string) {
    return getLock(string, ToolkitLockTypeInternal.WRITE);
  }

  @Override
  public ToolkitReadWriteLock getReadWriteLock(final String name) {
    return getOrCreateToolkitObject(ToolkitReadWriteLock.class, name, new Callable<ToolkitReadWriteLock>() {

      public ToolkitReadWriteLock call() throws Exception {
        return new NamedLocalReadWriteLock(name);
      }
    });
  }

  @Override
  public <E> ToolkitNotifier<E> getNotifier(final String name, Class<E> type) {
    return getOrCreateToolkitObject(ToolkitNotifier.class, name, new Callable<ToolkitNotifier>() {

      public ToolkitNotifier call() throws Exception {
        return new LocalNotifier(name);
      }
    });
  }

  @Override
  public ToolkitAtomicLong getAtomicLong(String string) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  @Override
  public ToolkitBarrier getBarrier(String string, int i) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  @Override
  public void fireOperatorEvent(OperatorEventLevel oel, String string, String string1) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  @Override
  public <E extends Comparable<? super E>> ToolkitSortedSet<E> getSortedSet(final String name, final Class<E> type) {
    return getOrCreateToolkitObject(ToolkitSortedSet.class, name, new Callable<ToolkitSortedSet>() {

      public ToolkitSortedSet<E> call() throws Exception {
        return new LocalSortedSet<E>(name, type);
      }
    });
  }

  @Override
  public <E> ToolkitSet<E> getSet(final String name, final Class<E> type) {
    return getOrCreateToolkitObject(ToolkitSet.class, name, new Callable<ToolkitSet>() {

      public ToolkitSet call() throws Exception {
        return new LocalSet<E>(name, type);
      }
    });
  }

  @Override
  public <V> ToolkitCache<String, V> getCache(final String name, final Configuration config, final Class<V> type) {
    return getOrCreateToolkitObject(ToolkitCache.class, name, new Callable<ToolkitCache>() {

      public ToolkitCache<String, V> call() throws Exception {
        return new LocalCache<String, V>(name, config, String.class, type);
      }
    });
  }

  @Override
  public <V> ToolkitCache<String, V> getCache(String string, Class<V> type) {
    return getCache(string, new ToolkitCacheConfigBuilder().build(), type);
  }

  @Override
  public void shutdown() {
    for (Runnable r : shutdownHooks) {
      new Thread(r).start();
    }
  }

  @Override
  public <T extends ToolkitFeature> T getFeature(ToolkitFeatureType<T> tft) {
    if (ToolkitFeatureType.NONSTOP.equals(tft)) {
      return tft.getFeatureClass().cast(nonstop);
    } else if (ToolkitFeatureType.SEARCH.equals(tft)) {
      return tft.getFeatureClass().cast(search);
    } else {
      throw new UnsupportedOperationException("Feature: " + tft + " not supported");
    }
  }

  private <T> T getOrCreateToolkitObject(Class<T> klazz, String name, Callable<T> generator) {
    ToolkitObjectIdentifier id = new ToolkitObjectIdentifier(klazz, name);
    T existing = (T) objects.get(id);
    if (existing == null) {
      T created;
      try {
        created = generator.call();
      } catch (Exception e) {
        throw new RuntimeException(e);
      }
      existing = (T) objects.putIfAbsent(id, created);
      if (existing == null) {
        return created;
      }
    }
    return existing;
  }

  static class ToolkitObjectIdentifier {

    private final Class<?> klazz;
    private final String name;

    public ToolkitObjectIdentifier(Class<?> klazz, String name) {
      this.klazz = klazz;
      this.name = name;
    }

    @Override
    public boolean equals(Object obj) {
      if (obj instanceof ToolkitObjectIdentifier) {
        ToolkitObjectIdentifier other = (ToolkitObjectIdentifier) obj;
        return klazz.equals(other.klazz) && name.equals(other.name);
      } else {
        return false;
      }
    }

    @Override
    public int hashCode() {
      return klazz.hashCode() ^ name.hashCode();
    }
  }
}
