/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.terracotta.upgradability.interaction;

import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import org.terracotta.toolkit.Toolkit;
import org.terracotta.toolkit.ToolkitFeatureType;
import org.terracotta.toolkit.ToolkitFeatureTypeInternal;
import org.terracotta.toolkit.ToolkitInstantiationException;
import org.terracotta.toolkit.api.ToolkitFactoryService;
import org.terracotta.toolkit.internal.ToolkitInternal;
import org.terracotta.toolkit.internal.concurrent.locks.ToolkitLockTypeInternal;
import org.terracotta.upgradability.interaction.localtoolkit.LocalToolkit;

import static org.mockito.Mockito.*;

/**
 *
 * @author cdennis
 */
public class MockToolkitFactoryService implements ToolkitFactoryService {

  private static final ConcurrentMap<ToolkitIdentifier, Toolkit> mocks = new ConcurrentHashMap<ToolkitIdentifier, Toolkit>();
  
  public static ToolkitInternal mockToolkitFor(String url) {
    ToolkitInternal spy = spy(new LocalToolkit());
    registerMock("terracotta", "//" + url, spy);
    registerMock("nonstop-terracotta", "//" + url, spy);
    return spy;
  }
  
  private static void registerMock(String type, String subname, Toolkit mock) {
    if (mocks.putIfAbsent(new ToolkitIdentifier(type, subname), mock) != null) {
      throw new IllegalStateException("Toolkit already registered");
    }
  }
  
  public static void allowNonPersistentInteractions(ToolkitInternal mock) {
    verify(mock, atLeast(0)).getClusterInfo();
    verify(mock, atLeast(0)).getLock(anyString(), any(ToolkitLockTypeInternal.class));
    verify(mock, atLeast(0)).getLock(anyString());
    verify(mock, atLeast(0)).getReadWriteLock(anyString());
    verify(mock, atLeast(0)).getFeature(any(ToolkitFeatureTypeInternal.class));
    verify(mock, atLeast(0)).getFeature(any(ToolkitFeatureType.class));
    verify(mock, atLeast(0)).getLogger(anyString());
    verify(mock, atLeast(0)).getNotifier(anyString(), any(Class.class));
    verify(mock, atLeast(0)).getClientUUID();
    verify(mock, atLeast(0)).registerBeforeShutdownHook(any(Runnable.class));
  }
  
  @Override
  public boolean canHandleToolkitType(String type, String subname) {
    return true;
  }

  @Override
  public Toolkit createToolkit(String type, String subname, Properties properties) throws ToolkitInstantiationException {
    return mocks.get(new ToolkitIdentifier(type, subname));
  }

  private static class ToolkitIdentifier {
    
    private final String type;
    private final String subname;
    
    public ToolkitIdentifier(String type, String subname) {
      this.type = type;
      this.subname = subname;
    }

    @Override
    public int hashCode() {
      return type.hashCode() ^ subname.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
      if (obj instanceof ToolkitIdentifier) {
        ToolkitIdentifier other = (ToolkitIdentifier) obj;
        return type.equals(other.type) && subname.equals(other.subname);
      } else {
        return false;
      }
    }
  }
}
