/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.terracotta.exception.ConnectionClosedException;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.RuntimeEntityException;
import org.terracotta.passthrough.Assert;
import org.terracotta.passthrough.PassthroughMonitor;

public class PassthroughWait
implements Future<byte[]> {
    private byte[] rawMessageForResend;
    private final boolean shouldWaitForReceived;
    private final boolean shouldWaitForCompleted;
    private final boolean shouldWaitForRetired;
    private final Set<Thread> waitingThreads;
    private boolean waitingForSent;
    private boolean waitingForReceive;
    private boolean waitingForComplete;
    private boolean waitingForRetired;
    private boolean forceGetToBlockOnRetire;
    private boolean canGetReturn;
    private byte[] response;
    private EntityException checkedException;
    private RuntimeEntityException uncheckedException;
    private final PassthroughMonitor monitor;

    public PassthroughWait(boolean shouldWaitForSent, boolean shouldWaitForReceived, boolean shouldWaitForCompleted, boolean shouldWaitForRetired, boolean forceGetToBlockOnRetire, PassthroughMonitor monitor) {
        this.shouldWaitForReceived = shouldWaitForReceived;
        this.shouldWaitForCompleted = shouldWaitForCompleted;
        this.shouldWaitForRetired = shouldWaitForRetired;
        this.waitingThreads = new HashSet<Thread>();
        this.waitingForSent = shouldWaitForSent;
        this.waitingForReceive = shouldWaitForReceived;
        this.waitingForComplete = shouldWaitForCompleted;
        this.waitingForRetired = shouldWaitForRetired;
        this.forceGetToBlockOnRetire = forceGetToBlockOnRetire;
        this.canGetReturn = false;
        this.response = null;
        this.monitor = monitor;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.interrupt();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    public synchronized void waitForAck() {
        boolean interrupted = false;
        while (this.waitingForSent || this.waitingForReceive || this.waitingForComplete || this.waitingForRetired) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public synchronized void interrupt() {
        for (Thread waitingThread : this.waitingThreads) {
            waitingThread.interrupt();
        }
    }

    @Override
    public synchronized boolean isDone() {
        return this.canGetReturn;
    }

    @Override
    public byte[] get() throws InterruptedException, ExecutionException {
        try {
            return this.waitForCompletion(0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException te) {
            Assert.unexpected(te);
            return null;
        }
        catch (EntityException e) {
            throw new ExecutionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized byte[] waitForCompletion(long timeout, TimeUnit unit) throws InterruptedException, EntityException, TimeoutException {
        Thread callingThread = Thread.currentThread();
        boolean didAdd = this.waitingThreads.add(callingThread);
        Assert.assertTrue(didAdd);
        long end = timeout > 0L ? System.currentTimeMillis() + unit.toMillis(timeout) : Long.MAX_VALUE;
        try {
            while (!this.canGetReturn && System.currentTimeMillis() < end) {
                this.wait(unit.toMillis(timeout));
            }
            if (!this.canGetReturn) {
                throw new TimeoutException();
            }
        }
        finally {
            this.waitingThreads.remove(callingThread);
        }
        if (null != this.checkedException) {
            throw this.checkedException;
        }
        if (null != this.uncheckedException) {
            throw this.uncheckedException;
        }
        return this.response;
    }

    @Override
    public byte[] get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return this.waitForCompletion(timeout, unit);
        }
        catch (EntityException e) {
            throw new ExecutionException(e);
        }
    }

    public synchronized void sent() {
        this.waitingForSent = false;
        this.notifyAll();
    }

    public synchronized void handleAck() {
        this.waitingForReceive = false;
        this.notifyAll();
    }

    public synchronized void handleComplete(byte[] result, EntityException error) {
        this.waitingForComplete = false;
        this.response = result;
        this.checkedException = error;
        if (!this.forceGetToBlockOnRetire) {
            this.canGetReturn = true;
        }
        this.notifyAll();
    }

    public synchronized void handleMonitor(byte[] result) {
        if (result != null) {
            this.monitor.sendResponse(result);
        }
    }

    public synchronized void handleRetire() {
        this.waitingForRetired = false;
        this.canGetReturn = true;
        this.notifyAll();
    }

    public void saveRawMessageForResend(byte[] raw) {
        this.rawMessageForResend = raw;
    }

    public synchronized byte[] resetAndGetMessageForResend() {
        this.waitingForReceive = this.shouldWaitForReceived;
        this.waitingForComplete = this.shouldWaitForCompleted;
        this.waitingForRetired = this.shouldWaitForRetired;
        this.canGetReturn = false;
        this.response = null;
        this.checkedException = null;
        return this.rawMessageForResend;
    }

    public synchronized void forceDisconnect() {
        this.waitingForComplete = false;
        this.uncheckedException = new ConnectionClosedException("Connection closed");
        this.canGetReturn = true;
        this.notifyAll();
    }

    public void blockGetOnRetire() {
        this.forceGetToBlockOnRetire = true;
    }
}

