/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.terracotta.passthrough.Assert;
import org.terracotta.passthrough.PassthroughMessageContainer;
import org.terracotta.persistence.IPlatformPersistence;

public class PassthroughTransactionOrderManager {
    private final IPlatformPersistence platformPersistence;
    private List<ClientTransaction> clientTransactionList;
    private long receivedTransactionCount;
    private Map<ClientTransaction, PassthroughMessageContainer> collectedResends;

    public PassthroughTransactionOrderManager(IPlatformPersistence platformPersistence, boolean shouldLoadStorage, Set<Long> savedClientConnections) {
        this.platformPersistence = platformPersistence;
        this.buildClientTransactionList(savedClientConnections, shouldLoadStorage);
    }

    public void updateTracking(long connectionID, long transactionID, long oldestIDOnConnection) {
        ++this.receivedTransactionCount;
        IPlatformPersistence.SequenceTuple sequenceTuple = new IPlatformPersistence.SequenceTuple();
        sequenceTuple.globalSequenceID = this.receivedTransactionCount;
        sequenceTuple.localSequenceID = transactionID;
        this.platformPersistence.fastStoreSequence(connectionID, sequenceTuple, oldestIDOnConnection);
    }

    public void startHandlingResends() {
        Assert.assertTrue(null == this.collectedResends);
        this.collectedResends = new HashMap<ClientTransaction, PassthroughMessageContainer>();
    }

    public void handleResend(long connectionID, long transactionID, PassthroughMessageContainer container) {
        Assert.assertTrue(null != this.collectedResends);
        ClientTransaction fakeTransaction = new ClientTransaction();
        fakeTransaction.connectionID = connectionID;
        fakeTransaction.transactionID = transactionID;
        this.collectedResends.put(fakeTransaction, container);
    }

    public List<PassthroughMessageContainer> stopHandlingResends() {
        Assert.assertTrue(null != this.collectedResends);
        Assert.assertTrue(null != this.clientTransactionList);
        Vector<PassthroughMessageContainer> orderToExecute = new Vector<PassthroughMessageContainer>();
        for (ClientTransaction transaction : this.clientTransactionList) {
            PassthroughMessageContainer container = this.collectedResends.remove(transaction);
            if (null == container) continue;
            orderToExecute.add(container);
        }
        for (PassthroughMessageContainer container : this.collectedResends.values()) {
            orderToExecute.add(container);
        }
        this.collectedResends = null;
        this.clientTransactionList = null;
        return orderToExecute;
    }

    private void buildClientTransactionList(Set<Long> savedClientConnections, boolean shouldLoadStorage) {
        if (shouldLoadStorage) {
            TreeMap<Long, ClientTransaction> sortMap = new TreeMap<Long, ClientTransaction>();
            for (long clientID : savedClientConnections) {
                List transactions = null;
                try {
                    transactions = this.platformPersistence.loadSequence(clientID);
                }
                catch (IOException e) {
                    Assert.unexpected(e);
                }
                if (transactions == null) continue;
                for (IPlatformPersistence.SequenceTuple tuple : transactions) {
                    ClientTransaction transaction = new ClientTransaction();
                    transaction.connectionID = clientID;
                    transaction.transactionID = tuple.localSequenceID;
                    sortMap.put(tuple.globalSequenceID, transaction);
                }
            }
            this.clientTransactionList = Collections.unmodifiableList(new ArrayList(sortMap.values()));
            this.receivedTransactionCount = sortMap.size() != 0 ? ((Long)sortMap.lastKey()).longValue() : new Long(0L).longValue();
        } else {
            this.clientTransactionList = Collections.emptyList();
            this.receivedTransactionCount = 0L;
        }
    }

    private static class ClientTransaction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public long connectionID;
        public long transactionID;

        private ClientTransaction() {
        }

        public boolean equals(Object obj) {
            boolean doesMatch;
            boolean bl = doesMatch = this == obj;
            if (!doesMatch && null != obj && this.getClass() == obj.getClass()) {
                ClientTransaction other = (ClientTransaction)obj;
                doesMatch = this.connectionID == other.connectionID && this.transactionID == other.transactionID;
            }
            return doesMatch;
        }

        public int hashCode() {
            return (int)this.connectionID << 16 | (int)this.transactionID;
        }
    }
}

