/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.terracotta.passthrough.Assert;

public class PassthroughTimerThread
extends Thread {
    private boolean shouldRun = true;
    private final AtomicLong nextNumber = new AtomicLong(1L);
    private final List<ListElement> queue = new ArrayList<ListElement>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean keepRunning = true;
        while (keepRunning) {
            NextIntent intent = this.getNextIntent();
            keepRunning = intent.keepRunning;
            if (!keepRunning) continue;
            Runnable toRun = intent.toRun;
            if (null != toRun) {
                try {
                    toRun.run();
                }
                catch (Throwable t) {
                    System.err.println("Unexpected exception in timer thread (timed events may be dropped)");
                    t.printStackTrace();
                }
                continue;
            }
            PassthroughTimerThread passthroughTimerThread = this;
            synchronized (passthroughTimerThread) {
                try {
                    this.wait(intent.millisToSleep);
                }
                catch (InterruptedException e) {
                    Assert.unexpected(e);
                }
            }
        }
    }

    public synchronized void shutdown() {
        this.shouldRun = false;
        this.notifyAll();
    }

    public synchronized long scheduleAfterDelay(Runnable runnable, long millisBeforeSend) {
        long currentTime = System.currentTimeMillis();
        long nextId = this.nextNumber.getAndIncrement();
        ListElement element = new ListElement(nextId, runnable, currentTime + millisBeforeSend, 0L);
        this.enqueueInList(element);
        return nextId;
    }

    public synchronized long schedulePeriodically(Runnable runnable, long millisBetweenSends) {
        long currentTime = System.currentTimeMillis();
        long nextId = this.nextNumber.getAndIncrement();
        ListElement element = new ListElement(nextId, runnable, currentTime + millisBetweenSends, millisBetweenSends);
        this.enqueueInList(element);
        return nextId;
    }

    public synchronized void cancelMessage(long token) {
        int indexToDrop = -1;
        for (int i = 0; -1 == indexToDrop && i < this.queue.size(); ++i) {
            if (this.queue.get((int)i).id != token) continue;
            indexToDrop = i;
        }
        if (-1 != indexToDrop) {
            this.queue.remove(indexToDrop);
        }
    }

    private synchronized NextIntent getNextIntent() {
        long currentTime = System.currentTimeMillis();
        boolean shouldContinue = this.shouldRun;
        Runnable toRun = null;
        long millisToSleep = 0L;
        if (shouldContinue && !this.queue.isEmpty()) {
            ListElement firstInList = this.queue.get(0);
            if (firstInList.timeToRun <= currentTime) {
                this.queue.remove(0);
                toRun = firstInList.toRun;
                long reschedulePeriod = firstInList.reschedulePeriod;
                if (reschedulePeriod > 0L) {
                    this.enqueueInList(new ListElement(firstInList.id, toRun, currentTime + reschedulePeriod, reschedulePeriod));
                }
            } else {
                millisToSleep = firstInList.timeToRun - currentTime;
            }
        }
        return new NextIntent(shouldContinue, toRun, millisToSleep);
    }

    private void enqueueInList(ListElement element) {
        int listSize;
        int indexToInsert = listSize = this.queue.size();
        for (int i = 0; i < listSize; ++i) {
            if (element.timeToRun >= this.queue.get((int)i).timeToRun) continue;
            indexToInsert = i;
            break;
        }
        this.queue.add(indexToInsert, element);
        this.notifyAll();
    }

    private static class NextIntent {
        public final boolean keepRunning;
        public final Runnable toRun;
        public final long millisToSleep;

        public NextIntent(boolean keepRunning, Runnable toRun, long millisToSleep) {
            this.keepRunning = keepRunning;
            this.toRun = toRun;
            this.millisToSleep = millisToSleep;
        }
    }

    private static class ListElement {
        public final long id;
        public final Runnable toRun;
        public final long timeToRun;
        public final long reschedulePeriod;

        public ListElement(long id, Runnable toRun, long timeToRun, long reschedulePeriod) {
            this.id = id;
            this.toRun = toRun;
            this.timeToRun = timeToRun;
            this.reschedulePeriod = reschedulePeriod;
        }
    }
}

