/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.util.Arrays;
import org.terracotta.passthrough.PassthroughClusterControl;
import org.terracotta.passthrough.PassthroughServer;

public class PassthroughTestHelpers {
    public static PassthroughClusterControl createActiveOnly(String stripeName, ServerInitializer initializer) {
        return PassthroughTestHelpers.createMultiServerStripe(stripeName, 1, initializer);
    }

    public static PassthroughClusterControl createActivePassive(String stripeName, ServerInitializer initializer) {
        return PassthroughTestHelpers.createMultiServerStripe(stripeName, 2, initializer);
    }

    public static PassthroughClusterControl createMultiServerStripe(String stripeName, int numOfServers, ServerInitializer initializer) {
        PassthroughServer[] servers = new PassthroughServer[numOfServers];
        for (int i = 0; i < numOfServers; ++i) {
            servers[i] = PassthroughTestHelpers.intializeServer(initializer);
            servers[i].setServerName(stripeName + "_" + i);
        }
        if (numOfServers == 1) {
            return new PassthroughClusterControl(stripeName, servers[0], new PassthroughServer[0]);
        }
        return new PassthroughClusterControl(stripeName, servers[0], Arrays.copyOfRange(servers, 1, servers.length));
    }

    private static PassthroughServer intializeServer(ServerInitializer initializer) {
        PassthroughServer activeServer = new PassthroughServer();
        initializer.registerServicesForServer(activeServer);
        return activeServer;
    }

    public static interface ServerInitializer {
        public void registerServicesForServer(PassthroughServer var1);
    }
}

