/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceException;
import org.terracotta.entity.ServiceProvider;
import org.terracotta.entity.ServiceRegistry;
import org.terracotta.passthrough.Assert;
import org.terracotta.passthrough.PassthroughImplementationProvidedServiceProvider;

public class PassthroughServiceRegistry
implements ServiceRegistry {
    private final String entityClassName;
    private final String entityName;
    private final long consumerID;
    private final List<ServiceProvider> serviceProviders;
    private final List<PassthroughImplementationProvidedServiceProvider> implementationProvidedServiceProviders;
    private final PassthroughImplementationProvidedServiceProvider.DeferredEntityContainer owningEntityContainer;

    public PassthroughServiceRegistry(String entityClassName, String entityName, long consumerID, List<ServiceProvider> serviceProviders, List<PassthroughImplementationProvidedServiceProvider> implementationProvidedServiceProviders, PassthroughImplementationProvidedServiceProvider.DeferredEntityContainer container) {
        this.entityClassName = entityClassName;
        this.entityName = entityName;
        this.consumerID = consumerID;
        ArrayList<ServiceProvider> services = new ArrayList<ServiceProvider>(serviceProviders);
        this.serviceProviders = Collections.unmodifiableList(services);
        this.implementationProvidedServiceProviders = Collections.unmodifiableList(implementationProvidedServiceProviders);
        this.owningEntityContainer = container;
    }

    public <T> T getService(ServiceConfiguration<T> configuration) throws ServiceException {
        T builtInService = this.getBuiltIn(configuration);
        T externalService = this.getExternal(configuration);
        if (builtInService != null && externalService != null) {
            throw new ServiceException("multiple services defined");
        }
        Assert.assertTrue(null == builtInService || null == externalService);
        return null != builtInService ? builtInService : externalService;
    }

    public <T> Collection<T> getServices(ServiceConfiguration<T> configuration) {
        return this.getExternals(configuration);
    }

    private <T> T getBuiltIn(ServiceConfiguration<T> configuration) throws ServiceException {
        Class serviceType = configuration.getServiceType();
        Object rService = null;
        for (PassthroughImplementationProvidedServiceProvider provider : this.implementationProvidedServiceProviders) {
            T service;
            if (!provider.getProvidedServiceTypes().contains(serviceType) || (service = provider.getService(this.entityClassName, this.entityName, this.consumerID, this.owningEntityContainer, configuration)) == null) continue;
            if (rService != null) {
                throw new ServiceException("multiple services defined");
            }
            return service;
        }
        return null;
    }

    private <T> T getExternal(ServiceConfiguration<T> configuration) throws ServiceException {
        Object rService = null;
        for (ServiceProvider provider : this.serviceProviders) {
            Object service;
            if (!provider.getProvidedServiceTypes().contains(configuration.getServiceType()) || (service = provider.getService(this.consumerID, configuration)) == null) continue;
            if (rService != null) {
                throw new ServiceException("multiple services defined");
            }
            rService = service;
        }
        return (T)rService;
    }

    private <T> Collection<T> getExternals(ServiceConfiguration<T> configuration) {
        ArrayList<Object> items = new ArrayList<Object>();
        for (ServiceProvider provider : this.serviceProviders) {
            Object service;
            if (!provider.getProvidedServiceTypes().contains(configuration.getServiceType()) || (service = provider.getService(this.consumerID, configuration)) == null) continue;
            items.add(service);
        }
        return items;
    }

    public long getConsumerID() {
        return this.consumerID;
    }
}

