/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.terracotta.entity.ActiveServerEntity;
import org.terracotta.entity.BasicServiceConfiguration;
import org.terracotta.entity.ClientDescriptor;
import org.terracotta.entity.CommonServerEntity;
import org.terracotta.entity.ConcurrencyStrategy;
import org.terracotta.entity.ConfigurationException;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.EntityServerService;
import org.terracotta.entity.EntityUserException;
import org.terracotta.entity.ExecutionStrategy;
import org.terracotta.entity.InvokeContext;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.entity.PassiveServerEntity;
import org.terracotta.entity.PlatformConfiguration;
import org.terracotta.entity.ReconnectRejectedException;
import org.terracotta.entity.ServiceException;
import org.terracotta.entity.ServiceProvider;
import org.terracotta.entity.ServiceProviderConfiguration;
import org.terracotta.entity.ServiceRegistry;
import org.terracotta.entity.SyncMessageCodec;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityConfigurationException;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.exception.EntityServerException;
import org.terracotta.exception.EntityVersionMismatchException;
import org.terracotta.monitoring.IMonitoringProducer;
import org.terracotta.monitoring.PlatformClientFetchedEntity;
import org.terracotta.monitoring.PlatformConnectedClient;
import org.terracotta.monitoring.PlatformEntity;
import org.terracotta.monitoring.PlatformMonitoringConstants;
import org.terracotta.monitoring.PlatformServer;
import org.terracotta.monitoring.ServerState;
import org.terracotta.passthrough.Assert;
import org.terracotta.passthrough.IAsynchronousServerCrasher;
import org.terracotta.passthrough.IFetchResult;
import org.terracotta.passthrough.IMessageSenderWrapper;
import org.terracotta.passthrough.PassThroughServerActiveInvokeContext;
import org.terracotta.passthrough.PassThroughServerInvokeContext;
import org.terracotta.passthrough.PassthroughClientDescriptor;
import org.terracotta.passthrough.PassthroughConnection;
import org.terracotta.passthrough.PassthroughDumper;
import org.terracotta.passthrough.PassthroughEntityTuple;
import org.terracotta.passthrough.PassthroughImplementationProvidedServiceProvider;
import org.terracotta.passthrough.PassthroughInterserverInterlock;
import org.terracotta.passthrough.PassthroughLifeCycleHandler;
import org.terracotta.passthrough.PassthroughMessage;
import org.terracotta.passthrough.PassthroughMessageCodec;
import org.terracotta.passthrough.PassthroughMessageContainer;
import org.terracotta.passthrough.PassthroughNullPlatformStorageServiceProvider;
import org.terracotta.passthrough.PassthroughPlatformConfiguration;
import org.terracotta.passthrough.PassthroughRetirementManager;
import org.terracotta.passthrough.PassthroughServerMessageDecoder;
import org.terracotta.passthrough.PassthroughServiceRegistry;
import org.terracotta.passthrough.PassthroughTransactionOrderManager;
import org.terracotta.passthrough.PassthroughUncaughtExceptionHandler;
import org.terracotta.persistence.IPlatformPersistence;
import org.terracotta.server.Server;
import org.terracotta.server.ServerEnv;
import org.terracotta.server.ServerJMX;
import org.terracotta.server.StopAction;

public class PassthroughServerProcess
implements PassthroughServerMessageDecoder.MessageHandler,
PassthroughDumper {
    private static final String ENTITIES_FILE_NAME = "entities.map";
    private final String serverName;
    private final int bindPort;
    private final int groupPort;
    private final PassthroughPlatformConfiguration platformConfiguration;
    private static final AtomicInteger CLIENT_PORT = new AtomicInteger(49152);
    private final int processID;
    private final Flag running = new Flag();
    private final List<EntityServerService<?, ?>> entityServices;
    private Thread serverThread;
    private Thread.UncaughtExceptionHandler crashHandler;
    private final BlockingQueue<PassthroughMessageContainer> messageQueue;
    private Map<PassthroughEntityTuple, CreationData<?, ?>> activeEntities;
    private Map<PassthroughEntityTuple, CreationData<?, ?>> passiveEntities;
    private final Map<Long, PassthroughImplementationProvidedServiceProvider.DeferredEntityContainer> consumerToLiveContainerMap;
    private final List<ServiceProvider> serviceProviders;
    private final List<PassthroughImplementationProvidedServiceProvider> implementationProvidedServiceProviders;
    private boolean serviceProvidersReadOnly;
    private final Set<PassthroughServerProcess> downstreamPassives = new HashSet<PassthroughServerProcess>();
    private long nextConsumerID;
    private IPlatformPersistence platformPersistence;
    private HashMap<Long, EntityData> persistedEntitiesByConsumerIDMap;
    private PassthroughServerMessageDecoder.LifeCycleMessageHandler lifeCycleMessageHandler;
    private final PassthroughRetirementManager retirementManager;
    private PassthroughTransactionOrderManager transactionOrderManager;
    private final IAsynchronousServerCrasher crasher;
    private static final AtomicInteger processIdGen = new AtomicInteger(0);
    private IMonitoringProducer serviceInterface;
    private PlatformServer serverInfo;
    private final Flag resending = new Flag();

    public PassthroughServerProcess(String serverName, int bindPort, int groupPort, Collection<Object> extendedConfigurationObjects, boolean isActiveMode, IAsynchronousServerCrasher crasher) {
        this.serverName = serverName;
        this.bindPort = bindPort;
        this.groupPort = groupPort;
        this.platformConfiguration = new PassthroughPlatformConfiguration(serverName, bindPort, extendedConfigurationObjects);
        this.entityServices = new Vector();
        this.messageQueue = new LinkedBlockingQueue<PassthroughMessageContainer>();
        this.activeEntities = isActiveMode ? new LinkedHashMap() : null;
        this.passiveEntities = isActiveMode ? null : new LinkedHashMap();
        this.consumerToLiveContainerMap = new HashMap<Long, PassthroughImplementationProvidedServiceProvider.DeferredEntityContainer>();
        this.serviceProviders = new Vector<ServiceProvider>();
        this.implementationProvidedServiceProviders = new Vector<PassthroughImplementationProvidedServiceProvider>();
        this.nextConsumerID = 0L;
        this.processID = processIdGen.incrementAndGet();
        this.retirementManager = new PassthroughRetirementManager();
        Assert.assertTrue(null != crasher);
        this.crasher = crasher;
    }

    void setCrashHandler(Thread.UncaughtExceptionHandler handler) {
        this.crashHandler = handler;
    }

    public boolean isServerThread() {
        return this.serverThread == Thread.currentThread();
    }

    public PassthroughRetirementManager getRetirementManager() {
        return this.retirementManager;
    }

    public void start(boolean shouldLoadStorage, Set<Long> savedClientConnections) {
        boolean isStorageInstalled = false;
        for (ServiceProvider provider : this.serviceProviders) {
            if (!provider.getProvidedServiceTypes().contains(IPlatformPersistence.class)) continue;
            isStorageInstalled = true;
            break;
        }
        if (!isStorageInstalled) {
            PassthroughNullPlatformStorageServiceProvider nullPlatformStorageServiceProvider = new PassthroughNullPlatformStorageServiceProvider();
            ServiceProviderConfiguration config = () -> PassthroughNullPlatformStorageServiceProvider.class;
            nullPlatformStorageServiceProvider.initialize(config, this.platformConfiguration);
            this.serviceProviders.add(nullPlatformStorageServiceProvider);
        }
        PassthroughServiceRegistry platformServiceRegistry = this.getNextServiceRegistry(null, null, null);
        try {
            this.platformPersistence = (IPlatformPersistence)platformServiceRegistry.getService(new BasicServiceConfiguration(IPlatformPersistence.class));
        }
        catch (ServiceException se) {
            throw new AssertionError((Object)se);
        }
        Assert.assertTrue(null != this.platformPersistence);
        try {
            this.persistedEntitiesByConsumerIDMap = (LinkedHashMap)(shouldLoadStorage ? this.platformPersistence.loadDataElement(ENTITIES_FILE_NAME) : null);
        }
        catch (IOException e1) {
            Assert.unexpected(e1);
        }
        if (null == this.persistedEntitiesByConsumerIDMap) {
            this.persistedEntitiesByConsumerIDMap = new LinkedHashMap<Long, EntityData>();
        }
        this.transactionOrderManager = new PassthroughTransactionOrderManager(this.platformPersistence, shouldLoadStorage, savedClientConnections);
        for (long consumerID : this.persistedEntitiesByConsumerIDMap.keySet()) {
            PassthroughImplementationProvidedServiceProvider.DeferredEntityContainer container = new PassthroughImplementationProvidedServiceProvider.DeferredEntityContainer();
            this.consumerToLiveContainerMap.put(consumerID, container);
            EntityData entityData = this.persistedEntitiesByConsumerIDMap.get(consumerID);
            PassthroughServiceRegistry registry = new PassthroughServiceRegistry(entityData.className, entityData.entityName, consumerID, this.serviceProviders, this.implementationProvidedServiceProviders, container);
            EntityServerService<?, ?> service = null;
            try {
                service = this.getServerEntityServiceForVersion(entityData.className, entityData.entityName, entityData.version);
            }
            catch (Exception e) {
                Assert.unexpected(e);
            }
            container.codec = service.getMessageCodec();
            PassthroughEntityTuple entityTuple = new PassthroughEntityTuple(entityData.className, entityData.entityName);
            CommonServerEntity<?, ?> newEntity = null;
            try {
                newEntity = this.createAndStoreEntity(entityData.className, entityData.entityName, entityData.version, entityData.configuration, entityTuple, service, registry, consumerID);
            }
            catch (ConfigurationException e) {
                Assert.unexpected(e);
            }
            container.setEntity(newEntity);
            if (newEntity instanceof ActiveServerEntity) {
                ((ActiveServerEntity)newEntity).loadExisting();
            }
            if (consumerID < this.nextConsumerID) continue;
            this.nextConsumerID = consumerID + 1L;
        }
        this.lifeCycleMessageHandler = new PassthroughLifeCycleHandler(this.platformPersistence, shouldLoadStorage);
        final Collection producers = platformServiceRegistry.getServices(new BasicServiceConfiguration(IMonitoringProducer.class));
        this.serviceInterface = new IMonitoringProducer(){

            public boolean addNode(String[] path, String name, Serializable value) {
                return producers.stream().map(p -> p.addNode(path, name, value)).reduce(Boolean.TRUE, Boolean::logicalAnd);
            }

            public boolean removeNode(String[] path, String name) {
                return producers.stream().map(p -> p.removeNode(path, name)).reduce(Boolean.TRUE, Boolean::logicalAnd);
            }

            public void pushBestEffortsData(String name, Serializable value) {
                producers.forEach(p -> p.pushBestEffortsData(name, value));
            }
        };
        if (null != this.serviceInterface) {
            this.serviceInterface.addNode(new String[0], "platform", null);
            this.serviceInterface.addNode(PlatformMonitoringConstants.PLATFORM_PATH, "clients", null);
            this.serviceInterface.addNode(PlatformMonitoringConstants.PLATFORM_PATH, "entities", null);
            this.serviceInterface.addNode(PlatformMonitoringConstants.PLATFORM_PATH, "fetched", null);
        }
        this.startServerThreadRunning();
    }

    public void resumeMessageProcessing() {
        this.startServerThreadRunning();
    }

    private void startServerThreadRunning() {
        Assert.assertTrue(null == this.serverThread);
        this.serverThread = new Thread(this::runServerThread);
        if (this.crashHandler != null) {
            this.serverThread.setUncaughtExceptionHandler(this.crashHandler);
        } else {
            this.serverThread.setUncaughtExceptionHandler(PassthroughUncaughtExceptionHandler.sharedInstance);
        }
        this.running.raise();
        this.serverInfo = new PlatformServer(this.getSafeServerName(), "localhost", "127.0.0.1", "0.0.0.0", this.bindPort, this.groupPort, "Version Passthrough 5.0.0-SNAPSHOT", "Build ID - " + new Random().nextInt(), System.currentTimeMillis());
        if (null != this.serviceInterface) {
            String stateValue = null != this.activeEntities ? "ACTIVE" : "UNINITIALIZED";
            long timestamp = System.currentTimeMillis();
            this.serviceInterface.addNode(PlatformMonitoringConstants.PLATFORM_PATH, "state", (Serializable)new ServerState(stateValue, timestamp, this.activeEntities != null ? timestamp : -1L));
        }
        this.serverThread.start();
    }

    private String getSafeServerName() {
        return this.serverName == null ? "server" + this.processID : this.serverName;
    }

    private void setStateSynchronizing(IMonitoringProducer tracker) {
        if (tracker != null) {
            long timestamp = System.currentTimeMillis();
            tracker.addNode(PlatformMonitoringConstants.PLATFORM_PATH, "state", (Serializable)new ServerState("SYNCHRONIZING", timestamp, this.activeEntities != null ? timestamp : -1L));
        }
    }

    public void registerEntityService(EntityServerService<?, ?> service) {
        this.entityServices.add(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Assert.assertTrue(!this.resending.isRaised());
        this.running.lower();
        PassthroughServerProcess passthroughServerProcess = this;
        synchronized (passthroughServerProcess) {
            if (null != this.serviceInterface) {
                this.serviceInterface.removeNode(PlatformMonitoringConstants.PLATFORM_PATH, "state");
            }
            this.serverThread.interrupt();
        }
        try {
            if (this.serverThread != null) {
                this.serverThread.join();
            }
        }
        catch (InterruptedException e) {
            Assert.unexpected(e);
        }
        this.messageQueue.clear();
        this.serverThread = null;
    }

    public void shutdownServices() {
        Assert.assertTrue(null != this.serverThread);
        for (ServiceProvider serviceProvider : this.serviceProviders) {
            if (serviceProvider instanceof Closeable) {
                try {
                    ((Closeable)serviceProvider).close();
                }
                catch (IOException e) {
                    Assert.unexpected(e);
                }
                continue;
            }
            if (!(serviceProvider instanceof AutoCloseable)) continue;
            try {
                ((AutoCloseable)serviceProvider).close();
            }
            catch (Exception e) {
                Assert.unexpected(e);
            }
        }
        for (PassthroughImplementationProvidedServiceProvider passthroughImplementationProvidedServiceProvider : this.implementationProvidedServiceProviders) {
            if (passthroughImplementationProvidedServiceProvider instanceof Closeable) {
                try {
                    ((Closeable)((Object)passthroughImplementationProvidedServiceProvider)).close();
                }
                catch (IOException e) {
                    Assert.unexpected(e);
                }
                continue;
            }
            if (!(passthroughImplementationProvidedServiceProvider instanceof AutoCloseable)) continue;
            try {
                ((AutoCloseable)((Object)passthroughImplementationProvidedServiceProvider)).close();
            }
            catch (Exception e) {
                Assert.unexpected(e);
            }
        }
        this.platformConfiguration.close();
    }

    public void sendMessageToServer(final PassthroughConnection sender, byte[] message) {
        if (!this.running.isRaised()) {
            throw new IllegalStateException("Connection already closed");
        }
        PassthroughMessageContainer container = new PassthroughMessageContainer();
        container.sender = new IMessageSenderWrapper(){
            int openCount = 0;
            PassthroughMessage retire;

            @Override
            public synchronized void open() {
                ++this.openCount;
            }

            @Override
            public void sendAck(PassthroughMessage ack) {
                sender.sendMessageToClient(PassthroughServerProcess.this, ack.asSerializedBytes());
            }

            @Override
            public void sendComplete(PassthroughMessage complete, boolean last) {
                sender.sendMessageToClient(PassthroughServerProcess.this, complete.asSerializedBytes());
            }

            @Override
            public synchronized void sendRetire(PassthroughMessage retired) {
                if (this.openCount == 0) {
                    PassthroughServerProcess.this.handleMessageRetirement(sender, retired);
                } else {
                    this.retire = retired;
                }
            }

            @Override
            public PassthroughClientDescriptor clientDescriptorForID(long clientInstanceID) {
                return new PassthroughClientDescriptor(PassthroughServerProcess.this, sender, clientInstanceID);
            }

            @Override
            public long getClientOriginID() {
                return sender.getUniqueConnectionID();
            }

            @Override
            public synchronized void close() {
                --this.openCount;
                if (this.openCount == 0 && this.retire != null) {
                    PassthroughServerProcess.this.handleMessageRetirement(sender, this.retire);
                }
            }
        };
        container.message = message;
        if (!this.resending.executeIfRaised(() -> {
            long connectionID = sender.getNewInstanceID();
            long transactionID = PassthroughMessageCodec.decodeTransactionIDFromRawMessage(message);
            this.transactionOrderManager.handleResend(connectionID, transactionID, container);
        })) {
            this.messageQueue.add(container);
        }
    }

    public void sendMessageToActiveFromInsideActive(final EntityMessage newMessage, PassthroughMessage passthroughMessage, final Consumer<PassthroughMessage> result) {
        if (!this.running.isRaised()) {
            return;
        }
        Assert.assertTrue(null != this.activeEntities);
        Assert.assertTrue(null != passthroughMessage);
        Assert.assertTrue(null != newMessage);
        Assert.assertTrue(!this.resending.isRaised());
        PassthroughMessageContainer container = new PassthroughMessageContainer();
        container.sender = new IMessageSenderWrapper(){

            @Override
            public void sendAck(PassthroughMessage ack) {
            }

            @Override
            public void sendComplete(PassthroughMessage complete, boolean last) {
                if (result != null) {
                    result.accept(complete);
                }
            }

            @Override
            public void sendRetire(PassthroughMessage retired) {
                PassthroughServerProcess.this.retireReadyItems(newMessage);
                PassthroughServerProcess.this.handleMessageRetirement(null, retired);
            }

            @Override
            public PassthroughClientDescriptor clientDescriptorForID(long clientInstanceID) {
                return null;
            }

            @Override
            public long getClientOriginID() {
                return -1L;
            }
        };
        container.message = passthroughMessage.asSerializedBytes();
        this.messageQueue.add(container);
    }

    private void retireReadyItems(EntityMessage messageRun) {
        if (null != this.activeEntities) {
            List<PassthroughRetirementManager.RetirementTuple> messagesToRetire = this.retirementManager.retireableListAfterMessageDone(messageRun);
            for (PassthroughRetirementManager.RetirementTuple oneTuple : messagesToRetire) {
                if (null == oneTuple.sender) continue;
                oneTuple.sender.sendMessageToClient(this, oneTuple.response);
            }
        }
    }

    private void handleMessageRetirement(PassthroughConnection sender, PassthroughMessage retired) {
        PassthroughRetirementManager.RetirementTuple tuple;
        if (null != this.activeEntities && !this.retirementManager.addRetirementTuple(tuple = new PassthroughRetirementManager.RetirementTuple(sender, retired.asSerializedBytes())) && null != sender) {
            sender.sendMessageToClient(this, tuple.response);
        }
    }

    public void sendMessageToServerFromActive(IMessageSenderWrapper senderCallback, byte[] message) {
        Assert.assertTrue(!this.resending.isRaised());
        PassthroughMessageContainer container = new PassthroughMessageContainer();
        container.sender = senderCallback;
        container.message = message;
        this.messageQueue.add(container);
    }

    private void setServerEnv() {
        ServerEnv.setServer((Server)new Server(){

            public int getServerCount() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public String[] processArguments() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void stop(StopAction ... actions) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public boolean stopIfPassive(StopAction ... actions) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public boolean stopIfActive(StopAction ... actions) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public boolean isActive() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public boolean isStopped() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public boolean isPassiveUnitialized() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public boolean isPassiveStandby() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public boolean isReconnectWindow() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public String getState() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public long getStartTime() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public long getActivateTime() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public String getIdentifier() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public int getClientPort() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public int getServerPort() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public int getReconnectWindowTimeout() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public boolean waitUntilShutdown() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void dump() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public String getClusterState() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public String getConfiguration() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public ClassLoader getServiceClassLoader(ClassLoader cl, Class<?> ... types) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public <T> List<Class<? extends T>> getImplementations(Class<T> type) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public ServerJMX getManagement() {
                return null;
            }

            public Properties getCurrentChannelProperties() {
                Properties props = new Properties();
                props.setProperty("username", "<<unknown>>");
                props.setProperty("address", "passthroough");
                return props;
            }

            public void warn(String string, Object ... os) {
            }

            public String getServerHostName() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void console(String string, Object ... os) {
            }

            public void audit(String string, Properties prprts) {
            }
        });
    }

    private void runServerThread() {
        Thread.currentThread().setName("Server thread isActive: " + (null != this.activeEntities ? "active" : "passive"));
        this.setServerEnv();
        PassthroughMessageContainer toRun = this.getNextMessage();
        while (null != toRun) {
            block3: {
                try {
                    IMessageSenderWrapper sender = toRun.sender;
                    byte[] message = toRun.message;
                    this.serverThreadHandleMessage(sender, message);
                }
                catch (Throwable t) {
                    if (!this.running.isRaised()) break block3;
                    throw t;
                }
            }
            toRun = this.getNextMessage();
        }
    }

    private PassthroughMessageContainer getNextMessage() {
        block3: {
            try {
                if (this.running.isRaised()) {
                    return this.messageQueue.take();
                }
            }
            catch (InterruptedException ie) {
                if (!this.running.isRaised()) break block3;
                Assert.unexpected(ie);
            }
        }
        return null;
    }

    private void serverThreadHandleMessage(IMessageSenderWrapper sender, byte[] message) {
        PassthroughServerMessageDecoder decoder = new PassthroughServerMessageDecoder(this, this, this.transactionOrderManager, this.lifeCycleMessageHandler, this.downstreamPassives, sender, this.crasher, message);
        PassthroughMessageCodec.decodeRawMessage(decoder, message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] invoke(IMessageSenderWrapper sender, long clientInstanceID, long transactionId, long eldestTransactionId, String entityClassName, String entityName, byte[] payload) throws EntityException {
        PassthroughEntityTuple entityTuple = new PassthroughEntityTuple(entityClassName, entityName);
        byte[] response = null;
        if (null != this.activeEntities) {
            CreationData<?, ?> data = this.activeEntities.get(entityTuple);
            if (null == data) throw new EntityNotFoundException(entityClassName, entityName);
            PassthroughClientDescriptor clientDescriptor = sender.clientDescriptorForID(clientInstanceID);
            return this.sendActiveInvocation(sender, entityClassName, entityName, clientDescriptor, transactionId, eldestTransactionId, data, payload);
        }
        CreationData<?, ?> data = this.passiveEntities.get(entityTuple);
        if (null == data) throw new EntityNotFoundException(entityClassName, entityName);
        PassthroughClientDescriptor clientDescriptor = sender.clientDescriptorForID(clientInstanceID);
        this.sendPassiveInvocation(entityClassName, entityName, clientDescriptor, transactionId, eldestTransactionId, data, payload);
        return response;
    }

    private <M extends EntityMessage, R extends EntityResponse> byte[] sendActiveInvocation(IMessageSenderWrapper sender, String className, String entityName, ClientDescriptor clientDescriptor, long transactionId, long eldestTransactionId, CreationData<M, R> data, byte[] payload) throws EntityException {
        ActiveServerEntity<M, R> entity = data.getActive();
        MessageCodec codec = data.messageCodec;
        Object msg = this.deserialize(className, entityName, codec, payload);
        if (data.executionStrategy.getExecutionLocation(msg).runOnActive()) {
            try {
                int cKey = data.concurrency.concurrencyKey(msg);
                EntityResponse response = entity.invokeActive(new PassThroughServerActiveInvokeContext(msg, clientDescriptor, cKey, transactionId, eldestTransactionId, sender, this.retirementManager, codec), msg);
                return this.serializeResponse(className, entityName, codec, response);
            }
            catch (EntityUserException eu) {
                throw new EntityServerException(className, entityName, eu.getLocalizedMessage(), (Throwable)eu);
            }
        }
        return new byte[0];
    }

    private <M extends EntityMessage, R extends EntityResponse> void sendPassiveInvocation(String className, String entityName, ClientDescriptor clientDescriptor, long transactionId, long eldestTransactionId, CreationData<M, R> data, byte[] payload) throws EntityException {
        PassiveServerEntity<M, R> entity = data.getPassive();
        MessageCodec codec = data.messageCodec;
        Object msg = this.deserialize(className, entityName, codec, payload);
        int cKey = data.concurrency.concurrencyKey(msg);
        if (data.executionStrategy.getExecutionLocation(msg).runOnPassive()) {
            try {
                entity.invokePassive((InvokeContext)new PassThroughServerInvokeContext(clientDescriptor.getSourceId(), cKey, transactionId, eldestTransactionId), msg);
            }
            catch (EntityUserException eu) {
                throw new EntityServerException(className, entityName, eu.getLocalizedMessage(), (Throwable)eu);
            }
        }
    }

    private <M extends EntityMessage, R extends EntityResponse> void sendPassiveSyncPayload(String className, String entityName, ClientDescriptor clientDescriptor, CreationData<M, R> data, int concurrencyKey, byte[] payload) throws EntityException {
        PassiveServerEntity<M, R> entity = data.getPassive();
        SyncMessageCodec codec = data.syncMessageCodec;
        try {
            entity.invokePassive((InvokeContext)new PassThroughServerInvokeContext(clientDescriptor.getSourceId(), concurrencyKey, -1L, -1L), this.deserializeForSync(className, entityName, codec, concurrencyKey, payload));
        }
        catch (EntityUserException eu) {
            throw new EntityServerException(className, entityName, eu.getLocalizedMessage(), (Throwable)eu);
        }
    }

    private <M extends EntityMessage, R extends EntityResponse> M deserialize(String className, String entityName, MessageCodec<M, R> codec, byte[] payload) throws EntityException {
        return (M)this.runWithHelper(className, entityName, () -> codec.decodeMessage(payload));
    }

    private <M extends EntityMessage, R extends EntityResponse> M deserializeForSync(String className, String entityName, SyncMessageCodec<M> codec, int concurrencyKey, byte[] payload) throws EntityException {
        return (M)this.runWithHelper(className, entityName, () -> codec.decode(concurrencyKey, payload));
    }

    private <M extends EntityMessage, R extends EntityResponse> byte[] serializeResponse(String className, String entityName, MessageCodec<M, R> codec, R response) throws EntityException {
        return this.runWithHelper(className, entityName, () -> codec.encodeResponse(response));
    }

    @Override
    public void dump() {
        System.out.println("Existing entities:");
        if (this.persistedEntitiesByConsumerIDMap != null) {
            for (EntityData entityData : this.persistedEntitiesByConsumerIDMap.values()) {
                System.out.println("\t" + entityData.className + ":" + entityData.entityName + ":" + entityData.version);
            }
        }
    }

    private <R> R runWithHelper(String className, String entityName, CodecHelper<R> helper) throws EntityException {
        R message;
        try {
            message = helper.run();
        }
        catch (MessageCodecException deserializationException) {
            throw new EntityServerException(className, entityName, deserializationException.getLocalizedMessage(), (Throwable)deserializationException);
        }
        catch (RuntimeException e) {
            MessageCodecException deserializationException = new MessageCodecException("Runtime exception in deserializer", (Throwable)e);
            throw new EntityServerException(className, entityName, deserializationException.getLocalizedMessage(), (Throwable)deserializationException);
        }
        return message;
    }

    @Override
    public void fetch(IMessageSenderWrapper sender, long clientInstanceID, String entityClassName, String entityName, long version, IFetchResult onFetch) {
        PassthroughEntityTuple entityTuple = new PassthroughEntityTuple(entityClassName, entityName);
        byte[] config = null;
        EntityNotFoundException error = null;
        Assert.assertTrue(null != this.activeEntities);
        CreationData<?, ?> entityData = this.activeEntities.get(entityTuple);
        PassthroughClientDescriptor clientDescriptor = sender.clientDescriptorForID(clientInstanceID);
        if (null != entityData && entityData.reference(clientDescriptor)) {
            ActiveServerEntity<?, ?> entity = entityData.getActive();
            EntityServerService<?, ?> service = this.getEntityServiceForClassName(entityClassName);
            long expectedVersion = service.getVersion();
            if (expectedVersion == version) {
                config = entityData.configuration;
                if (null != this.serviceInterface) {
                    String clientIdentifier = this.clientIdentifierForService(sender.getClientOriginID());
                    String entityIdentifier = this.entityIdentifierForService(entityClassName, entityName);
                    PlatformClientFetchedEntity record = new PlatformClientFetchedEntity(clientIdentifier, entityIdentifier, (ClientDescriptor)clientDescriptor);
                    String fetchIdentifier = this.fetchIdentifierForService(clientIdentifier, entityIdentifier);
                    this.serviceInterface.addNode(PlatformMonitoringConstants.FETCHED_PATH, fetchIdentifier, (Serializable)record);
                }
                entity.connected((ClientDescriptor)clientDescriptor);
            } else {
                error = new EntityVersionMismatchException(entityClassName, entityName, expectedVersion, version);
            }
        } else {
            error = new EntityNotFoundException(entityClassName, entityName);
        }
        if (entityData != null && error != null) {
            entityData.release(clientDescriptor);
        }
        onFetch.onFetchComplete(config, (EntityException)error);
    }

    @Override
    public void release(IMessageSenderWrapper sender, long clientInstanceID, String entityClassName, String entityName) throws EntityException {
        PassthroughEntityTuple entityTuple = new PassthroughEntityTuple(entityClassName, entityName);
        if (this.activeEntities != null) {
            CreationData<?, ?> data = this.activeEntities.get(entityTuple);
            if (null != data) {
                ActiveServerEntity<?, ?> entity = data.getActive();
                PassthroughClientDescriptor clientDescriptor = sender.clientDescriptorForID(clientInstanceID);
                entity.disconnected((ClientDescriptor)clientDescriptor);
                data.release(clientDescriptor);
                if (null != this.serviceInterface) {
                    String clientIdentifier = this.clientIdentifierForService(sender.getClientOriginID());
                    String entityIdentifier = this.entityIdentifierForService(entityClassName, entityName);
                    String fetchIdentifier = this.fetchIdentifierForService(clientIdentifier, entityIdentifier);
                    this.serviceInterface.removeNode(PlatformMonitoringConstants.FETCHED_PATH, fetchIdentifier);
                }
            } else {
                throw new EntityNotFoundException(entityClassName, entityName);
            }
        }
    }

    @Override
    public synchronized void create(String entityClassName, String entityName, long version, byte[] serializedConfiguration) throws EntityException {
        CommonServerEntity<?, ?> newEntity;
        CreationData<?, ?> shell;
        PassthroughEntityTuple entityTuple = new PassthroughEntityTuple(entityClassName, entityName);
        if (this.activeEntities != null ? (shell = this.activeEntities.get(entityTuple)) != null && !shell.isDestroyed : this.passiveEntities.containsKey(entityTuple)) {
            throw new EntityAlreadyExistsException(entityClassName, entityName);
        }
        long consumerID = this.nextConsumerID;
        EntityServerService<?, ?> service = this.getServerEntityServiceForVersion(entityClassName, entityName, version);
        PassthroughImplementationProvidedServiceProvider.DeferredEntityContainer container = new PassthroughImplementationProvidedServiceProvider.DeferredEntityContainer();
        container.codec = service.getMessageCodec();
        this.consumerToLiveContainerMap.put(consumerID, container);
        PassthroughServiceRegistry registry = this.getNextServiceRegistry(entityClassName, entityName, container);
        try {
            newEntity = this.createAndStoreEntity(entityClassName, entityName, version, serializedConfiguration, entityTuple, service, registry, consumerID);
            newEntity.createNew();
        }
        catch (ConfigurationException e) {
            if (this.activeEntities != null) {
                this.activeEntities.remove(entityTuple);
            } else {
                this.passiveEntities.remove(entityTuple);
            }
            throw new EntityConfigurationException(entityClassName, entityName, (Throwable)e);
        }
        container.setEntity(newEntity);
        if (null != this.serviceInterface) {
            boolean isActive = null != this.activeEntities;
            PlatformEntity record = new PlatformEntity(entityClassName, entityName, consumerID, isActive);
            String entityIdentifier = this.entityIdentifierForService(entityClassName, entityName);
            this.serviceInterface.addNode(PlatformMonitoringConstants.ENTITIES_PATH, entityIdentifier, (Serializable)record);
        }
        EntityData data = new EntityData();
        data.className = entityClassName;
        data.version = version;
        data.entityName = entityName;
        data.configuration = serializedConfiguration;
        this.persistedEntitiesByConsumerIDMap.put(consumerID, data);
        try {
            this.platformPersistence.storeDataElement(ENTITIES_FILE_NAME, this.persistedEntitiesByConsumerIDMap);
        }
        catch (IOException e) {
            Assert.unexpected(e);
        }
    }

    @Override
    public byte[] reconfigure(String entityClassName, String entityName, long version, byte[] serializedConfiguration) throws EntityException {
        CreationData<?, ?> entityData;
        PassthroughEntityTuple entityTuple = new PassthroughEntityTuple(entityClassName, entityName);
        CreationData<?, ?> creationData = entityData = this.activeEntities != null ? this.activeEntities.get(entityTuple) : this.passiveEntities.get(entityTuple);
        if (null != this.serviceInterface) {
            PlatformEntity record = new PlatformEntity(entityClassName, entityName, entityData.consumerID, entityData.isActive);
            String entityIdentifier = this.entityIdentifierForService(entityClassName, entityName);
            this.serviceInterface.addNode(PlatformMonitoringConstants.ENTITIES_PATH, entityIdentifier, (Serializable)record);
        }
        try {
            byte[] reconfigured = entityData.reconfigure(serializedConfiguration);
            EntityData data = this.persistedEntitiesByConsumerIDMap.get(entityData.consumerID);
            Assert.assertTrue(data != null);
            data.configuration = serializedConfiguration;
            try {
                this.platformPersistence.storeDataElement(ENTITIES_FILE_NAME, this.persistedEntitiesByConsumerIDMap);
            }
            catch (IOException e) {
                Assert.unexpected(e);
            }
            return reconfigured;
        }
        catch (ConfigurationException e) {
            throw new EntityConfigurationException(entityClassName, entityName, (Throwable)e);
        }
    }

    @Override
    public synchronized boolean destroy(String entityClassName, String entityName) throws EntityException {
        boolean success;
        PassthroughEntityTuple entityTuple = new PassthroughEntityTuple(entityClassName, entityName);
        CreationData<?, ?> entityData = null != this.activeEntities ? this.activeEntities.get(entityTuple) : this.passiveEntities.remove(entityTuple);
        if (null != entityData && !entityData.isDestroyed) {
            success = entityData.destroy();
            if (success) {
                Assert.assertTrue(entityData.consumerID > 0L);
                PassthroughImplementationProvidedServiceProvider.DeferredEntityContainer container = this.consumerToLiveContainerMap.remove(entityData.consumerID);
                Assert.assertTrue(null != container);
                Assert.assertTrue(this.persistedEntitiesByConsumerIDMap.remove(entityData.consumerID) != null);
                try {
                    this.platformPersistence.storeDataElement(ENTITIES_FILE_NAME, this.persistedEntitiesByConsumerIDMap);
                }
                catch (IOException e) {
                    Assert.unexpected(e);
                }
                container.clearEntity();
            }
            if (success && null != this.activeEntities) {
                boolean didRemove = false;
                if (entityData.equals(this.activeEntities.get(entityTuple))) {
                    this.activeEntities.remove(entityTuple);
                    didRemove = true;
                }
                Assert.assertTrue(didRemove);
            }
        } else {
            throw new EntityNotFoundException(entityClassName, entityName);
        }
        if (success && null != this.serviceInterface) {
            String entityIdentifier = this.entityIdentifierForService(entityClassName, entityName);
            this.serviceInterface.removeNode(PlatformMonitoringConstants.ENTITIES_PATH, entityIdentifier);
        }
        return success;
    }

    @Override
    public void reconnect(IMessageSenderWrapper sender, long clientInstanceID, String entityClassName, String entityName, byte[] extendedData) {
        PassthroughEntityTuple entityTuple = new PassthroughEntityTuple(entityClassName, entityName);
        Assert.assertTrue(null != this.activeEntities);
        CreationData<?, ?> entityData = this.activeEntities.get(entityTuple);
        if (null != entityData) {
            PassthroughClientDescriptor clientDescriptor = sender.clientDescriptorForID(clientInstanceID);
            try {
                entityData.reconnect(clientInstanceID, clientDescriptor, extendedData);
            }
            catch (ReconnectRejectedException e) {
                throw new RuntimeException(e);
            }
        } else {
            Assert.unexpected(new Exception("Entity not found in reconnect"));
        }
    }

    @Override
    public void syncEntityStart(IMessageSenderWrapper sender, String entityClassName, String entityName) throws EntityException {
        Assert.assertTrue(null != this.passiveEntities);
        PassthroughEntityTuple entityTuple = new PassthroughEntityTuple(entityClassName, entityName);
        CreationData<?, ?> data = this.passiveEntities.get(entityTuple);
        if (null == data) {
            throw new EntityNotFoundException(entityClassName, entityName);
        }
        PassiveServerEntity<?, ?> entity = data.getPassive();
        entity.startSyncEntity();
    }

    @Override
    public void syncEntityEnd(IMessageSenderWrapper sender, String entityClassName, String entityName) throws EntityException {
        Assert.assertTrue(null != this.passiveEntities);
        PassthroughEntityTuple entityTuple = new PassthroughEntityTuple(entityClassName, entityName);
        CreationData<?, ?> data = this.passiveEntities.get(entityTuple);
        if (null == data) {
            throw new EntityNotFoundException(entityClassName, entityName);
        }
        PassiveServerEntity<?, ?> entity = data.getPassive();
        entity.endSyncEntity();
    }

    @Override
    public void syncEntityKeyStart(IMessageSenderWrapper sender, String entityClassName, String entityName, int concurrencyKey) throws EntityException {
        Assert.assertTrue(null != this.passiveEntities);
        PassthroughEntityTuple entityTuple = new PassthroughEntityTuple(entityClassName, entityName);
        CreationData<?, ?> data = this.passiveEntities.get(entityTuple);
        if (null == data) {
            throw new EntityNotFoundException(entityClassName, entityName);
        }
        PassiveServerEntity<?, ?> entity = data.getPassive();
        entity.startSyncConcurrencyKey(concurrencyKey);
    }

    @Override
    public void syncEntityKeyEnd(IMessageSenderWrapper sender, String entityClassName, String entityName, int concurrencyKey) throws EntityException {
        Assert.assertTrue(null != this.passiveEntities);
        PassthroughEntityTuple entityTuple = new PassthroughEntityTuple(entityClassName, entityName);
        CreationData<?, ?> data = this.passiveEntities.get(entityTuple);
        if (null == data) {
            throw new EntityNotFoundException(entityClassName, entityName);
        }
        PassiveServerEntity<?, ?> entity = data.getPassive();
        entity.endSyncConcurrencyKey(concurrencyKey);
    }

    @Override
    public void syncPayload(IMessageSenderWrapper sender, String entityClassName, String entityName, int concurrencyKey, byte[] payload) throws EntityException {
        Assert.assertTrue(null != this.passiveEntities);
        PassthroughEntityTuple entityTuple = new PassthroughEntityTuple(entityClassName, entityName);
        CreationData<?, ?> data = this.passiveEntities.get(entityTuple);
        if (null == data) {
            throw new EntityNotFoundException(entityClassName, entityName);
        }
        PassthroughClientDescriptor cdescr = sender.clientDescriptorForID(sender.getClientOriginID());
        this.sendPassiveSyncPayload(entityClassName, entityName, cdescr, data, concurrencyKey, payload);
    }

    private String clientIdentifierForService(long connectionID) {
        return "" + connectionID;
    }

    private String entityIdentifierForService(String entityClassName, String entityName) {
        return entityClassName + entityName;
    }

    private String fetchIdentifierForService(String clientIdentifier, String entityIdentifier) {
        return clientIdentifier + entityIdentifier;
    }

    private EntityServerService<?, ?> getEntityServiceForClassName(String entityClassName) {
        EntityServerService<?, ?> foundService = null;
        for (EntityServerService<?, ?> service : this.entityServices) {
            if (!service.handlesEntityType(entityClassName)) continue;
            Assert.assertTrue(null == foundService);
            foundService = service;
        }
        return foundService;
    }

    public void registerImplementationProvidedServiceProvider(PassthroughImplementationProvidedServiceProvider serviceProvider, ServiceProviderConfiguration providerConfiguration) {
        Assert.assertTrue(!this.serviceProvidersReadOnly);
        this.implementationProvidedServiceProviders.add(serviceProvider);
    }

    public void registerServiceProvider(ServiceProvider serviceProvider, ServiceProviderConfiguration providerConfiguration) {
        Assert.assertTrue(!this.serviceProvidersReadOnly);
        boolean didInitialize = serviceProvider.initialize(providerConfiguration, (PlatformConfiguration)this.platformConfiguration);
        if (didInitialize) {
            this.serviceProviders.add(serviceProvider);
        }
    }

    public synchronized void addDownstreamPassiveServerProcess(PassthroughServerProcess serverProcess) {
        Assert.assertTrue(null != this.activeEntities);
        Assert.assertTrue(null != serverProcess.passiveEntities);
        this.downstreamPassives.add(serverProcess);
        serverProcess.setStateSynchronizing(serverProcess.serviceInterface);
        for (Map.Entry<PassthroughEntityTuple, CreationData<?, ?>> entry : this.activeEntities.entrySet()) {
            CreationData<?, ?> value = entry.getValue();
            String entityClassName = value.entityClassName;
            String entityName = value.entityName;
            PassthroughMessage entityStart = PassthroughMessageCodec.createSyncEntityStartMessage(entityClassName, entityName, value.version, value.configuration);
            PassthroughInterserverInterlock wrapper = new PassthroughInterserverInterlock(null);
            serverProcess.sendMessageToServerFromActive(wrapper, entityStart.asSerializedBytes());
            wrapper.waitForComplete();
            for (Integer oneKey : value.getConcurrency().getKeysForSynchronization()) {
                PassthroughMessage keyStart = PassthroughMessageCodec.createSyncEntityKeyStartMessage(entityClassName, entityName, oneKey);
                wrapper = new PassthroughInterserverInterlock(null);
                serverProcess.sendMessageToServerFromActive(wrapper, keyStart.asSerializedBytes());
                wrapper.waitForComplete();
                value.synchronizeToPassive(serverProcess, oneKey);
                PassthroughMessage keyEnd = PassthroughMessageCodec.createSyncEntityKeyEndMessage(entityClassName, entityName, oneKey);
                wrapper = new PassthroughInterserverInterlock(null);
                serverProcess.sendMessageToServerFromActive(wrapper, keyEnd.asSerializedBytes());
                wrapper.waitForComplete();
            }
            PassthroughMessage entityEnd = PassthroughMessageCodec.createSyncEntityEndMessage(entityClassName, entityName);
            wrapper = new PassthroughInterserverInterlock(null);
            serverProcess.sendMessageToServerFromActive(wrapper, entityEnd.asSerializedBytes());
            wrapper.waitForComplete();
        }
        if (null != serverProcess.serviceInterface) {
            long timestamp = System.currentTimeMillis();
            serverProcess.serviceInterface.addNode(PlatformMonitoringConstants.PLATFORM_PATH, "state", (Serializable)new ServerState("PASSIVE", timestamp, timestamp));
        }
    }

    public synchronized void removeDownstreamPassiveServerProcess(PassthroughServerProcess serverProcess) {
        boolean didRemove = this.downstreamPassives.remove(serverProcess);
        Assert.assertTrue(didRemove);
    }

    public void promoteToActive() {
        Assert.assertTrue(null != this.passiveEntities);
        this.downstreamPassives.clear();
        this.activeEntities = new HashMap();
        for (Map.Entry<PassthroughEntityTuple, CreationData<?, ?>> entry : this.passiveEntities.entrySet()) {
            CreationData<?, ?> data = entry.getValue();
            CreationData<?, ?> newData = null;
            try {
                newData = this.buildCreationDataForPromotion(data);
            }
            catch (ConfigurationException e) {
                Assert.unexpected(e);
            }
            newData.getActive().loadExisting();
            this.activeEntities.put(entry.getKey(), newData);
        }
        if (this.serviceInterface != null) {
            long timestamp = System.currentTimeMillis();
            this.serviceInterface.addNode(PlatformMonitoringConstants.PLATFORM_PATH, "state", (Serializable)new ServerState("ACTIVE", timestamp, timestamp));
        }
        this.passiveEntities = null;
    }

    private <M extends EntityMessage, R extends EntityResponse> CreationData<M, R> buildCreationDataForPromotion(CreationData<M, R> data) throws ConfigurationException {
        return new CreationData(data.entityClassName, data.entityName, data.version, data.configuration, data.registry, data.service, true, data.consumerID);
    }

    public void connectConnection(PassthroughConnection connection, long connectionID) {
        if (null != this.serviceInterface) {
            InetAddress localHost = null;
            try {
                localHost = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                Assert.unexpected(e);
            }
            String uuid = connection.getUUID();
            Assert.assertTrue(null != uuid);
            String connectionName = connection.getConnectionName();
            Assert.assertTrue(null != connectionName);
            PlatformConnectedClient clientDescription = new PlatformConnectedClient(uuid, connectionName, localHost, this.bindPort, localHost, CLIENT_PORT.getAndIncrement(), Long.parseLong(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]));
            String nodeName = this.clientIdentifierForService(connectionID);
            this.serviceInterface.addNode(PlatformMonitoringConstants.CLIENTS_PATH, nodeName, (Serializable)clientDescription);
        }
    }

    public void disconnectConnection(PassthroughConnection connection, long connectionID) {
        if (null != this.serviceInterface) {
            String nodeName = this.clientIdentifierForService(connectionID);
            this.serviceInterface.removeNode(PlatformMonitoringConstants.CLIENTS_PATH, nodeName);
        }
    }

    public void beginReceivingResends() {
        if (null != this.transactionOrderManager) {
            Assert.assertTrue(!this.resending.isRaised());
            this.transactionOrderManager.startHandlingResends();
            this.resending.raise();
        }
    }

    public void endReceivingResends() {
        if (null != this.transactionOrderManager) {
            this.resending.executeIfRaised(() -> {
                List<PassthroughMessageContainer> list = this.transactionOrderManager.stopHandlingResends();
                this.messageQueue.addAll(list);
                this.resending.lower();
            });
        }
    }

    public PassthroughServiceRegistry createServiceRegistryForInternalConsumer(String entityClassName, String entityName, long consumerID, PassthroughImplementationProvidedServiceProvider.DeferredEntityContainer container) {
        this.serviceProvidersReadOnly = true;
        return new PassthroughServiceRegistry(entityClassName, entityName, consumerID, this.serviceProviders, this.implementationProvidedServiceProviders, container);
    }

    public PlatformServer getServerInfo() {
        return this.serverInfo;
    }

    private PassthroughServiceRegistry getNextServiceRegistry(String entityClassName, String entityName, PassthroughImplementationProvidedServiceProvider.DeferredEntityContainer container) {
        long thisConsumerID = this.nextConsumerID++;
        this.serviceProvidersReadOnly = true;
        return new PassthroughServiceRegistry(entityClassName, entityName, thisConsumerID, this.serviceProviders, this.implementationProvidedServiceProviders, container);
    }

    private EntityServerService<?, ?> getServerEntityServiceForVersion(String entityClassName, String entityName, long version) throws EntityVersionMismatchException, EntityNotProvidedException {
        EntityServerService<?, ?> service = this.getEntityServiceForClassName(entityClassName);
        if (service == null) {
            throw new EntityNotProvidedException(entityClassName, entityName);
        }
        long expectedVersion = service.getVersion();
        if (expectedVersion != version) {
            throw new EntityVersionMismatchException(entityClassName, entityName, expectedVersion, version);
        }
        return service;
    }

    private <M extends EntityMessage, R extends EntityResponse> CommonServerEntity<M, R> createAndStoreEntity(String entityClassName, String entityName, long version, byte[] serializedConfiguration, PassthroughEntityTuple entityTuple, EntityServerService<M, R> service, PassthroughServiceRegistry registry, long consumerID) throws ConfigurationException {
        ActiveServerEntity<M, R> newEntity;
        boolean isActive = null != this.activeEntities;
        CreationData<M, R> data = new CreationData<M, R>(entityClassName, entityName, version, serializedConfiguration, registry, service, isActive, consumerID);
        if (isActive) {
            this.activeEntities.put(entityTuple, data);
            newEntity = data.getActive();
        } else {
            this.passiveEntities.put(entityTuple, data);
            newEntity = data.getPassive();
        }
        return newEntity;
    }

    private static class Flag {
        private boolean flagged;

        private Flag() {
        }

        public synchronized void raise() {
            Assert.assertTrue(!this.flagged);
            this.flagged = true;
        }

        public synchronized void lower() {
            Assert.assertTrue(this.flagged);
            this.flagged = false;
            this.notifyAll();
        }

        public synchronized boolean isRaised() {
            return this.flagged;
        }

        public synchronized boolean executeIfRaised(Runnable r) {
            if (this.flagged) {
                r.run();
            }
            return this.flagged;
        }

        public synchronized void waitForLower() throws InterruptedException {
            while (this.flagged) {
                this.wait();
            }
        }
    }

    private static class CreationData<M extends EntityMessage, R extends EntityResponse> {
        public final String entityClassName;
        public final String entityName;
        public final long version;
        public byte[] configuration;
        public final PassthroughServiceRegistry registry;
        public final EntityServerService<M, R> service;
        public CommonServerEntity<M, R> entityInstance;
        public ActiveServerEntity.ReconnectHandler reconnect;
        public final MessageCodec<M, R> messageCodec;
        public final SyncMessageCodec<M> syncMessageCodec;
        public ConcurrencyStrategy<M> concurrency;
        public ExecutionStrategy<M> executionStrategy;
        public final boolean isActive;
        public final long consumerID;
        public boolean isDestroyed = false;
        public Map<ClientDescriptor, Integer> references = new HashMap<ClientDescriptor, Integer>();

        public CreationData(String entityClassName, String entityName, long version, byte[] configuration, PassthroughServiceRegistry registry, EntityServerService<M, R> service, boolean isActive, long consumerID) throws ConfigurationException {
            this.entityClassName = entityClassName;
            this.entityName = entityName;
            this.version = version;
            this.configuration = configuration;
            this.registry = registry;
            this.service = service;
            this.messageCodec = service.getMessageCodec();
            this.syncMessageCodec = service.getSyncMessageCodec();
            this.entityInstance = isActive ? service.createActiveEntity((ServiceRegistry)registry, configuration) : service.createPassiveEntity((ServiceRegistry)registry, configuration);
            this.reconnect = isActive ? this.getActive().startReconnect() : null;
            this.concurrency = service.getConcurrencyStrategy(configuration);
            Objects.nonNull(this.concurrency);
            this.executionStrategy = service.getExecutionStrategy(configuration);
            this.isActive = isActive;
            this.consumerID = consumerID;
        }

        synchronized boolean reference(ClientDescriptor cid) {
            Integer current;
            Assert.assertTrue(this.isActive);
            if (!this.isDestroyed && (current = this.references.putIfAbsent(cid, 1)) != null) {
                throw new AssertionError(current);
            }
            return !this.isDestroyed;
        }

        synchronized boolean release(ClientDescriptor cid) {
            Assert.assertTrue(this.isActive);
            Integer current = this.references.remove(cid);
            if (current == null) {
                return false;
            }
            if (current == 1) {
                return true;
            }
            throw new AssertionError((Object)"makes no sense");
        }

        synchronized boolean destroy() {
            if (!(this.isDestroyed || this.isActive && !this.references.isEmpty())) {
                this.entityInstance.destroy();
                this.isDestroyed = true;
            }
            return this.isDestroyed;
        }

        byte[] reconfigure(byte[] data) throws ConfigurationException {
            try {
                this.entityInstance = this.service.reconfigureEntity((ServiceRegistry)this.registry, this.entityInstance, data);
                this.concurrency = this.service.getConcurrencyStrategy(data);
                this.executionStrategy = this.service.getExecutionStrategy(data);
                byte[] byArray = this.configuration;
                return byArray;
            }
            finally {
                this.configuration = data;
            }
        }

        synchronized void reconnect(long clientid, ClientDescriptor clientDescriptor, byte[] data) throws ReconnectRejectedException {
            Assert.assertTrue(this.isActive);
            this.reference(clientDescriptor);
            this.getActive().connected(clientDescriptor);
            if (this.reconnect == null) {
                throw new ReconnectRejectedException("no reconnect handler");
            }
            this.reconnect.handleReconnect(clientDescriptor, data);
            this.reconnect.close();
        }

        public ActiveServerEntity<M, R> getActive() {
            return (ActiveServerEntity)ActiveServerEntity.class.cast(this.entityInstance);
        }

        public PassiveServerEntity<M, R> getPassive() {
            return (PassiveServerEntity)PassiveServerEntity.class.cast(this.entityInstance);
        }

        public ConcurrencyStrategy<M> getConcurrency() {
            return this.concurrency;
        }

        public void synchronizeToPassive(PassthroughServerProcess passive, int key) {
            this.getActive().prepareKeyForSynchronizeOnPassive(payload -> {
                PassthroughMessage payloadMessage = PassthroughMessageCodec.createSyncPayloadMessage(this.entityClassName, this.entityName, key, this.serialize(key, payload));
                PassthroughInterserverInterlock wrapper = new PassthroughInterserverInterlock(null);
                passive.sendMessageToServerFromActive(wrapper, payloadMessage.asSerializedBytes());
                wrapper.waitForComplete();
            }, key);
            this.getActive().synchronizeKeyToPassive(payload -> {
                PassthroughMessage payloadMessage = PassthroughMessageCodec.createSyncPayloadMessage(this.entityClassName, this.entityName, key, this.serialize(key, payload));
                PassthroughInterserverInterlock wrapper = new PassthroughInterserverInterlock(null);
                passive.sendMessageToServerFromActive(wrapper, payloadMessage.asSerializedBytes());
                wrapper.waitForComplete();
            }, key);
        }

        private byte[] serialize(int key, M message) {
            try {
                return this.syncMessageCodec.encode(key, message);
            }
            catch (MessageCodecException me) {
                throw new RuntimeException(me);
            }
        }
    }

    private static class EntityData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String className;
        public long version;
        public String entityName;
        public byte[] configuration;

        private EntityData() {
        }
    }

    private static interface CodecHelper<R> {
        public R run() throws MessageCodecException;
    }
}

