/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityServerException;
import org.terracotta.passthrough.Assert;
import org.terracotta.passthrough.IAsynchronousServerCrasher;
import org.terracotta.passthrough.IFetchResult;
import org.terracotta.passthrough.IMessageSenderWrapper;
import org.terracotta.passthrough.PassthroughInterserverInterlock;
import org.terracotta.passthrough.PassthroughMessage;
import org.terracotta.passthrough.PassthroughMessageCodec;
import org.terracotta.passthrough.PassthroughServerProcess;
import org.terracotta.passthrough.PassthroughTransactionOrderManager;

public class PassthroughServerMessageDecoder
implements PassthroughMessageCodec.Decoder<Void> {
    private final PassthroughServerProcess thisServer;
    private final MessageHandler messageHandler;
    private final PassthroughTransactionOrderManager transactionOrderManager;
    private final LifeCycleMessageHandler lifeCycleMessageHandler;
    private final Set<PassthroughServerProcess> downstreamPassives = new HashSet<PassthroughServerProcess>();
    private final IMessageSenderWrapper sender;
    private final IAsynchronousServerCrasher crasher;
    private final byte[] message;

    public PassthroughServerMessageDecoder(PassthroughServerProcess thisServer, MessageHandler messageHandler, PassthroughTransactionOrderManager transactionOrderManager, LifeCycleMessageHandler lifeCycleMessageHandler, Set<PassthroughServerProcess> downstreamPassives, IMessageSenderWrapper sender, IAsynchronousServerCrasher crasher, byte[] message) {
        this.thisServer = thisServer;
        this.messageHandler = messageHandler;
        this.transactionOrderManager = transactionOrderManager;
        this.lifeCycleMessageHandler = lifeCycleMessageHandler;
        this.downstreamPassives.addAll(downstreamPassives);
        this.sender = sender;
        this.crasher = crasher;
        this.message = message;
    }

    @Override
    public Void decode(PassthroughMessage.Type type, boolean shouldReplicate, final long transactionID, long oldestTransactionID, DataInputStream input) throws IOException {
        long originID = this.sender.getClientOriginID();
        if (null != this.transactionOrderManager && originID >= 0L) {
            this.transactionOrderManager.updateTracking(originID, transactionID, oldestTransactionID);
        }
        PassthroughMessage ack = PassthroughMessageCodec.createAckMessage();
        long oldestTransactionIDToReturn = -1L;
        ack.setTransactionTracking(transactionID, oldestTransactionIDToReturn);
        this.sender.sendAck(ack);
        HashSet<PassthroughServerProcess> failingServers = new HashSet<PassthroughServerProcess>();
        if (shouldReplicate && this.downstreamPassives.size() > 0) {
            for (PassthroughServerProcess passive : this.downstreamPassives) {
                PassthroughInterserverInterlock wrapper = new PassthroughInterserverInterlock(this.sender);
                passive.sendMessageToServerFromActive(wrapper, this.message);
                boolean didSucceed = wrapper.waitForComplete();
                if (didSucceed) continue;
                failingServers.add(passive);
            }
        }
        switch (type) {
            case CREATE_ENTITY: {
                boolean shouldSendResponse;
                long clientOriginID = this.sender.getClientOriginID();
                String entityClassName = input.readUTF();
                String entityName = input.readUTF();
                long version = input.readLong();
                byte[] serializedConfiguration = new byte[input.readInt()];
                input.readFully(serializedConfiguration);
                byte[] response = null;
                EntityException error = null;
                boolean didAlreadyHandle = false;
                try {
                    didAlreadyHandle = this.lifeCycleMessageHandler.didAlreadyHandle(clientOriginID, transactionID);
                }
                catch (EntityException e) {
                    error = e;
                    didAlreadyHandle = true;
                }
                if (!didAlreadyHandle) {
                    try {
                        this.messageHandler.create(entityClassName, entityName, version, serializedConfiguration);
                    }
                    catch (EntityException e) {
                        error = e;
                    }
                    catch (RuntimeException e) {
                        error = new EntityServerException(entityClassName, entityName, e.getLocalizedMessage(), (Throwable)e);
                    }
                    if (null == error) {
                        this.lifeCycleMessageHandler.successInMessage(clientOriginID, transactionID, oldestTransactionID, null);
                    } else {
                        this.lifeCycleMessageHandler.failureInMessage(clientOriginID, transactionID, oldestTransactionID, error);
                    }
                }
                if (!(shouldSendResponse = this.handleConsensus(failingServers, error))) break;
                this.sendCompleteResponse(this.sender, transactionID, response, error);
                break;
            }
            case RECONFIGURE_ENTITY: {
                boolean shouldSendResponse;
                long clientOriginID = this.sender.getClientOriginID();
                String entityClassName = input.readUTF();
                String entityName = input.readUTF();
                long version = input.readLong();
                byte[] serializedConfiguration = new byte[input.readInt()];
                input.readFully(serializedConfiguration);
                byte[] response = null;
                EntityException error = null;
                boolean didAlreadyHandle = false;
                try {
                    response = this.lifeCycleMessageHandler.didAlreadyHandleResult(clientOriginID, transactionID);
                    if (null != response) {
                        didAlreadyHandle = true;
                    }
                }
                catch (EntityException e) {
                    error = e;
                    didAlreadyHandle = true;
                }
                if (!didAlreadyHandle) {
                    try {
                        response = this.messageHandler.reconfigure(entityClassName, entityName, version, serializedConfiguration);
                    }
                    catch (EntityException e) {
                        error = e;
                    }
                    catch (RuntimeException e) {
                        error = new EntityServerException(entityClassName, entityName, e.getLocalizedMessage(), (Throwable)e);
                    }
                    if (null == error) {
                        this.lifeCycleMessageHandler.successInMessage(clientOriginID, transactionID, oldestTransactionID, response);
                    } else {
                        this.lifeCycleMessageHandler.failureInMessage(clientOriginID, transactionID, oldestTransactionID, error);
                    }
                }
                if (!(shouldSendResponse = this.handleConsensus(failingServers, error))) break;
                this.sendCompleteResponse(this.sender, transactionID, response, error);
                break;
            }
            case DESTROY_ENTITY: {
                long clientOriginID = this.sender.getClientOriginID();
                String entityClassName = input.readUTF();
                String entityName = input.readUTF();
                byte[] response = null;
                EntityException error = null;
                try {
                    response = this.lifeCycleMessageHandler.didAlreadyHandleResult(clientOriginID, transactionID);
                }
                catch (EntityException e) {
                    error = e;
                }
                if (response == null && error == null) {
                    try {
                        boolean did = this.messageHandler.destroy(entityClassName, entityName);
                        response = new byte[]{did ? (byte)1 : 0};
                    }
                    catch (EntityException e) {
                        error = e;
                    }
                    catch (RuntimeException e) {
                        error = new EntityServerException(entityClassName, entityName, e.getLocalizedMessage(), (Throwable)e);
                    }
                    if (null == error) {
                        this.lifeCycleMessageHandler.successInMessage(clientOriginID, transactionID, oldestTransactionID, response);
                    } else {
                        this.lifeCycleMessageHandler.failureInMessage(clientOriginID, transactionID, oldestTransactionID, error);
                    }
                }
                Assert.assertTrue(response != null || error != null);
                this.sendCompleteResponse(this.sender, transactionID, response, error);
                break;
            }
            case DOES_ENTITY_EXIST: {
                Assert.unimplemented();
                break;
            }
            case FETCH_ENTITY: {
                String entityClassName = input.readUTF();
                String entityName = input.readUTF();
                long clientInstanceID = input.readLong();
                long version = input.readLong();
                IFetchResult onFetch = new IFetchResult(){

                    @Override
                    public void onFetchComplete(byte[] config, EntityException error) {
                        PassthroughServerMessageDecoder.this.sendCompleteResponse(PassthroughServerMessageDecoder.this.sender, transactionID, config, error);
                    }
                };
                try {
                    this.messageHandler.fetch(this.sender, clientInstanceID, entityClassName, entityName, version, onFetch);
                }
                catch (RuntimeException e) {
                    EntityServerException error = new EntityServerException(entityClassName, entityName, e.getLocalizedMessage(), (Throwable)e);
                    byte[] response = null;
                    this.sendCompleteResponse(this.sender, transactionID, response, (EntityException)error);
                }
                break;
            }
            case RELEASE_ENTITY: {
                String entityClassName = input.readUTF();
                String entityName = input.readUTF();
                long clientInstanceID = input.readLong();
                byte[] response = null;
                EntityException error = null;
                try {
                    this.messageHandler.release(this.sender, clientInstanceID, entityClassName, entityName);
                }
                catch (EntityException e) {
                    error = e;
                }
                catch (RuntimeException e) {
                    error = new EntityServerException(entityClassName, entityName, e.getLocalizedMessage(), (Throwable)e);
                }
                this.sendCompleteResponse(this.sender, transactionID, response, error);
                break;
            }
            case UNEXPECTED_RELEASE: {
                String entityClassName = input.readUTF();
                String entityName = input.readUTF();
                long clientInstanceID = input.readLong();
                try {
                    this.messageHandler.release(this.sender, clientInstanceID, entityClassName, entityName);
                }
                catch (Exception e) {
                    Assert.unexpected(e);
                }
                byte[] response = null;
                EntityException error = null;
                this.sendCompleteResponse(this.sender, transactionID, response, error);
                break;
            }
            case INVOKE_ON_SERVER: {
                String entityClassName = input.readUTF();
                String entityName = input.readUTF();
                long clientInstanceID = input.readLong();
                byte[] payload = new byte[input.readInt()];
                input.readFully(payload);
                byte[] response = null;
                EntityException error = null;
                try {
                    response = this.messageHandler.invoke(this.sender, clientInstanceID, transactionID, oldestTransactionID, entityClassName, entityName, payload);
                }
                catch (EntityException e) {
                    error = e;
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    error = new EntityServerException(entityClassName, entityName, e.getLocalizedMessage(), (Throwable)e);
                }
                this.sendCompleteResponse(this.sender, transactionID, response, error);
                break;
            }
            case ACK_FROM_SERVER: 
            case COMPLETE_FROM_SERVER: 
            case EXCEPTION_FROM_SERVER: 
            case MONITOR_MESSAGE: 
            case MONITOR_EXCEPTION: 
            case RETIRE_FROM_SERVER: 
            case INVOKE_ON_CLIENT: {
                Assert.unreachable();
                break;
            }
            case RECONNECT: {
                String entityClassName = input.readUTF();
                String entityName = input.readUTF();
                long clientInstanceID = input.readLong();
                int extendedDataLength = input.readInt();
                byte[] extendedData = new byte[extendedDataLength];
                input.readFully(extendedData);
                byte[] response = null;
                EntityServerException error = null;
                try {
                    this.messageHandler.reconnect(this.sender, clientInstanceID, entityClassName, entityName, extendedData);
                    response = new byte[]{};
                }
                catch (RuntimeException e) {
                    error = new EntityServerException(entityClassName, entityName, e.getLocalizedMessage(), (Throwable)e);
                }
                this.sendCompleteResponse(this.sender, transactionID, response, (EntityException)error);
                break;
            }
            case SYNC_ENTITY_START: {
                String entityClassName = input.readUTF();
                String entityName = input.readUTF();
                long version = input.readLong();
                byte[] serializedConfiguration = new byte[input.readInt()];
                input.readFully(serializedConfiguration);
                EntityException error = null;
                try {
                    this.messageHandler.create(entityClassName, entityName, version, serializedConfiguration);
                    this.messageHandler.syncEntityStart(this.sender, entityClassName, entityName);
                }
                catch (EntityException e) {
                    error = e;
                }
                catch (RuntimeException e) {
                    error = new EntityServerException(entityClassName, entityName, e.getLocalizedMessage(), (Throwable)e);
                }
                byte[] response = null;
                this.sendCompleteResponse(this.sender, transactionID, response, error);
                break;
            }
            case SYNC_ENTITY_END: {
                String entityClassName = input.readUTF();
                String entityName = input.readUTF();
                EntityException error = null;
                try {
                    this.messageHandler.syncEntityEnd(this.sender, entityClassName, entityName);
                }
                catch (EntityException e) {
                    error = e;
                }
                catch (RuntimeException e) {
                    error = new EntityServerException(entityClassName, entityName, e.getLocalizedMessage(), (Throwable)e);
                }
                byte[] response = null;
                this.sendCompleteResponse(this.sender, transactionID, response, error);
                break;
            }
            case SYNC_ENTITY_KEY_START: {
                String entityClassName = input.readUTF();
                String entityName = input.readUTF();
                int concurrencyKey = input.readInt();
                EntityException error = null;
                try {
                    this.messageHandler.syncEntityKeyStart(this.sender, entityClassName, entityName, concurrencyKey);
                }
                catch (EntityException e) {
                    error = e;
                }
                catch (RuntimeException e) {
                    error = new EntityServerException(entityClassName, entityName, e.getLocalizedMessage(), (Throwable)e);
                }
                byte[] response = null;
                this.sendCompleteResponse(this.sender, transactionID, response, error);
                break;
            }
            case SYNC_ENTITY_KEY_END: {
                String entityClassName = input.readUTF();
                String entityName = input.readUTF();
                int concurrencyKey = input.readInt();
                EntityException error = null;
                try {
                    this.messageHandler.syncEntityKeyEnd(this.sender, entityClassName, entityName, concurrencyKey);
                }
                catch (EntityException e) {
                    error = e;
                }
                catch (RuntimeException e) {
                    error = new EntityServerException(entityClassName, entityName, e.getLocalizedMessage(), (Throwable)e);
                }
                byte[] response = null;
                this.sendCompleteResponse(this.sender, transactionID, response, error);
                break;
            }
            case SYNC_ENTITY_PAYLOAD: {
                String entityClassName = input.readUTF();
                String entityName = input.readUTF();
                int concurrencyKey = input.readInt();
                byte[] payload = new byte[input.readInt()];
                input.readFully(payload);
                EntityException error = null;
                try {
                    this.messageHandler.syncPayload(this.sender, entityClassName, entityName, concurrencyKey, payload);
                }
                catch (EntityException e) {
                    error = e;
                }
                catch (RuntimeException e) {
                    error = new EntityServerException(entityClassName, entityName, e.getLocalizedMessage(), (Throwable)e);
                }
                byte[] response = null;
                this.sendCompleteResponse(this.sender, transactionID, response, error);
                break;
            }
            default: {
                Assert.unreachable();
            }
        }
        return null;
    }

    private boolean handleConsensus(Set<PassthroughServerProcess> failingServers, EntityException error) {
        boolean shouldSendResponse = true;
        if (null == error) {
            for (PassthroughServerProcess serverProcess : failingServers) {
                this.crasher.terminateServerProcess(serverProcess);
            }
        } else if (this.downstreamPassives.size() != failingServers.size()) {
            for (PassthroughServerProcess serverProcess : failingServers) {
                this.crasher.terminateServerProcess(serverProcess);
                shouldSendResponse = false;
            }
            this.crasher.terminateServerProcess(this.thisServer);
        }
        return shouldSendResponse;
    }

    private void sendCompleteResponse(IMessageSenderWrapper sender, long transactionID, byte[] response, EntityException error) {
        if (error != null) {
            // empty if block
        }
        PassthroughMessage complete = PassthroughMessageCodec.createCompleteMessage(response, error);
        long oldestTransactionID = -1L;
        complete.setTransactionTracking(transactionID, oldestTransactionID);
        sender.sendComplete(complete, true);
        PassthroughMessage retire = PassthroughMessageCodec.createRetireMessage();
        retire.setTransactionTracking(transactionID, oldestTransactionID);
        sender.sendRetire(retire);
    }

    public static interface LifeCycleMessageHandler {
        public boolean didAlreadyHandle(long var1, long var3) throws EntityException;

        public byte[] didAlreadyHandleResult(long var1, long var3) throws EntityException;

        public void failureInMessage(long var1, long var3, long var5, EntityException var7);

        public void successInMessage(long var1, long var3, long var5, byte[] var7);
    }

    public static interface MessageHandler {
        public void create(String var1, String var2, long var3, byte[] var5) throws EntityException;

        public byte[] reconfigure(String var1, String var2, long var3, byte[] var5) throws EntityException;

        public boolean destroy(String var1, String var2) throws EntityException;

        public void fetch(IMessageSenderWrapper var1, long var2, String var4, String var5, long var6, IFetchResult var8);

        public void release(IMessageSenderWrapper var1, long var2, String var4, String var5) throws EntityException;

        public byte[] invoke(IMessageSenderWrapper var1, long var2, long var4, long var6, String var8, String var9, byte[] var10) throws EntityException;

        public void reconnect(IMessageSenderWrapper var1, long var2, String var4, String var5, byte[] var6);

        public void syncEntityStart(IMessageSenderWrapper var1, String var2, String var3) throws EntityException;

        public void syncEntityEnd(IMessageSenderWrapper var1, String var2, String var3) throws EntityException;

        public void syncEntityKeyStart(IMessageSenderWrapper var1, String var2, String var3, int var4) throws EntityException;

        public void syncEntityKeyEnd(IMessageSenderWrapper var1, String var2, String var3, int var4) throws EntityException;

        public void syncPayload(IMessageSenderWrapper var1, String var2, String var3, int var4, byte[] var5) throws EntityException;
    }
}

