/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.util.ArrayList;
import java.util.List;
import org.terracotta.passthrough.Assert;
import org.terracotta.passthrough.IAsynchronousServerCrasher;
import org.terracotta.passthrough.PassthroughClusterControl;
import org.terracotta.passthrough.PassthroughServerProcess;

public class PassthroughServerCrasher
implements IAsynchronousServerCrasher {
    private final PassthroughClusterControl control;
    private boolean isRunning = false;
    private final List<PassthroughServerProcess> victimQueue;
    private final Thread background = new Thread(){

        @Override
        public void run() {
            PassthroughServerProcess victim = PassthroughServerCrasher.this.waitNextRequest();
            while (null != victim) {
                PassthroughServerCrasher.this.control.restartOneServerFromInside(victim);
                victim = PassthroughServerCrasher.this.waitNextRequest();
            }
        }
    };

    public PassthroughServerCrasher(PassthroughClusterControl control) {
        this.control = control;
        this.victimQueue = new ArrayList<PassthroughServerProcess>();
    }

    @Override
    public synchronized void terminateServerProcess(PassthroughServerProcess victim) {
        boolean shouldNotify = this.victimQueue.isEmpty();
        this.victimQueue.add(victim);
        if (shouldNotify) {
            this.notifyAll();
        }
    }

    public synchronized PassthroughServerProcess waitNextRequest() {
        while (this.isRunning && this.victimQueue.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Assert.unexpected(e);
            }
        }
        PassthroughServerProcess process = null;
        if (this.isRunning) {
            process = this.victimQueue.remove(0);
        }
        return process;
    }

    public void start() {
        this.isRunning = true;
        this.background.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForStop() {
        PassthroughServerCrasher passthroughServerCrasher = this;
        synchronized (passthroughServerCrasher) {
            this.isRunning = false;
            this.notifyAll();
        }
        try {
            this.background.join();
        }
        catch (InterruptedException e) {
            Assert.unexpected(e);
        }
    }
}

