/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import com.tc.classloader.BuiltinService;
import com.tc.classloader.OverrideService;
import com.tc.classloader.OverrideServiceType;
import com.tc.classloader.PermanentEntity;
import com.tc.classloader.PermanentEntityType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.terracotta.entity.EntityClientService;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.EntityServerService;
import org.terracotta.entity.ServiceProvider;
import org.terracotta.entity.ServiceProviderConfiguration;
import org.terracotta.exception.EntityException;
import org.terracotta.passthrough.IAsynchronousServerCrasher;
import org.terracotta.passthrough.PassthroughClusterControl;
import org.terracotta.passthrough.PassthroughCommunicatorServiceProvider;
import org.terracotta.passthrough.PassthroughConnection;
import org.terracotta.passthrough.PassthroughDumper;
import org.terracotta.passthrough.PassthroughEndpointConnector;
import org.terracotta.passthrough.PassthroughEndpointConnectorImpl;
import org.terracotta.passthrough.PassthroughMessengerServiceProvider;
import org.terracotta.passthrough.PassthroughMonitoringProducer;
import org.terracotta.passthrough.PassthroughPlatformServiceProvider;
import org.terracotta.passthrough.PassthroughServerProcess;

public class PassthroughServer
implements PassthroughDumper {
    private static final AtomicLong nextConnectionID = new AtomicLong(0L);
    private String serverName;
    private int bindPort;
    private int groupPort;
    private boolean isActive;
    private PassthroughServerProcess serverProcess;
    private boolean hasStarted;
    private final List<EntityClientService<?, ?, ? extends EntityMessage, ? extends EntityResponse, ?>> entityClientServices = new Vector();
    private PassthroughMonitoringProducer monitoringProducer;
    private IAsynchronousServerCrasher crasher;
    private final List<EntityServerService<?, ?>> savedServerEntityServices = new Vector();
    private final List<ServiceProviderAndConfiguration> savedServiceProviderData = new Vector<ServiceProviderAndConfiguration>();
    private final Collection<Object> extendedConfigurationObjects = new Vector<Object>();
    private final Map<Long, PassthroughConnection> savedClientConnections = new HashMap<Long, PassthroughConnection>();
    private PassthroughClusterControl passthroughClusterControl;

    public void registerAsynchronousServerCrasher(IAsynchronousServerCrasher crasher) {
        Assert.assertNull((Object)this.crasher);
        this.crasher = crasher;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setBindPort(int bindPort) {
        this.bindPort = bindPort;
    }

    public void setGroupPort(int groupPort) {
        this.groupPort = groupPort;
    }

    public void registerServerEntityService(EntityServerService<?, ?> service) {
        Assert.assertFalse((boolean)this.hasStarted);
        this.savedServerEntityServices.add(service);
    }

    public void registerClientEntityService(EntityClientService<?, ?, ? extends EntityMessage, ? extends EntityResponse, ?> service) {
        Assert.assertFalse((boolean)this.hasStarted);
        this.entityClientServices.add(service);
    }

    public PassthroughConnection connectNewClient(String connectionName) {
        return this.connectNewClient(connectionName, new PassthroughEndpointConnectorImpl());
    }

    public synchronized PassthroughConnection connectNewClient(String connectionName, PassthroughEndpointConnector endpointConnector) {
        Assert.assertTrue((boolean)this.hasStarted);
        final long thisConnectionID = nextConnectionID.incrementAndGet();
        Runnable onClose = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PassthroughServer passthroughServer = PassthroughServer.this;
                synchronized (passthroughServer) {
                    PassthroughConnection closedConnection = (PassthroughConnection)PassthroughServer.this.savedClientConnections.remove(thisConnectionID);
                    if (closedConnection != null) {
                        PassthroughServer.this.serverProcess.disconnectConnection(closedConnection, thisConnectionID);
                    }
                }
            }
        };
        String readerThreadName = "Client connection " + thisConnectionID;
        PassthroughConnection connection = new PassthroughConnection(connectionName, readerThreadName, this.serverProcess, this.entityClientServices, onClose, thisConnectionID, endpointConnector);
        connection.startProcessingRequests();
        this.serverProcess.connectConnection(connection, thisConnectionID);
        this.savedClientConnections.put(thisConnectionID, connection);
        return connection;
    }

    public void start(boolean isActive, boolean shouldLoadStorage) {
        this.start(isActive, shouldLoadStorage, Collections.emptySet());
    }

    public void start(boolean isActive, boolean shouldLoadStorage, Set<Long> savedClientConnections) {
        this.isActive = isActive;
        this.hasStarted = true;
        this.bootstrapProcess(this.isActive);
        this.serverProcess.start(shouldLoadStorage, savedClientConnections);
        if (this.isActive) {
            if (!shouldLoadStorage) {
                this.addPermanentEntities();
            }
            this.monitoringProducer.didBecomeActive(this.serverProcess.getServerInfo());
        }
    }

    private void addPermanentEntities() {
        for (EntityServerService<?, ?> serverEntityService : this.savedServerEntityServices) {
            try {
                for (PermanentEntity permanentEntity : (PermanentEntity[])serverEntityService.getClass().getAnnotationsByType(PermanentEntity.class)) {
                    this.serverProcess.create(permanentEntity.type(), permanentEntity.name(), permanentEntity.version(), new byte[0]);
                }
                for (PermanentEntity permanentEntity : (PermanentEntityType[])serverEntityService.getClass().getAnnotationsByType(PermanentEntityType.class)) {
                    this.serverProcess.create(permanentEntity.type().getName(), permanentEntity.name(), permanentEntity.version(), new byte[0]);
                }
            }
            catch (EntityException exp) {
                throw new RuntimeException(exp);
            }
        }
    }

    private void bootstrapProcess(boolean active) {
        this.serverProcess = new PassthroughServerProcess(this.serverName, this.bindPort, this.groupPort, this.extendedConfigurationObjects, active, this.crasher);
        for (EntityServerService<?, ?> serverEntityService : this.savedServerEntityServices) {
            this.serverProcess.registerEntityService(serverEntityService);
        }
        this.registerImplementationProvidedServices();
        this.findClasspathBuiltinServices();
        this.internalInstallServiceProvider();
        this.serverProcess.setCrashHandler((t, e) -> {
            System.err.println("FATAL EXCEPTION IN PASSTHROUGH SERVER THREAD: " + t);
            e.printStackTrace();
            if (this.isActive) {
                this.disconnectClients();
            }
        });
    }

    private void internalInstallServiceProvider() {
        for (ServiceProviderAndConfiguration tuple : this.savedServiceProviderData) {
            try {
                this.serverProcess.registerServiceProvider((ServiceProvider)tuple.serviceProvider.getClass().newInstance(), tuple.providerConfiguration);
            }
            catch (IllegalAccessException a) {
                throw new RuntimeException(a);
            }
            catch (InstantiationException i) {
                throw new RuntimeException(i);
            }
        }
    }

    public void stop() {
        this.internalStop();
    }

    private void internalStop() {
        this.serverProcess.shutdownServices();
        this.serverProcess.stop();
        this.monitoringProducer.serverDidStop();
    }

    @Deprecated
    public <T> void registerServiceProviderForType(Class<T> clazz, ServiceProvider serviceProvider, ServiceProviderConfiguration providerConfiguration) {
        this.internalRegisterServiceProvider(serviceProvider, providerConfiguration);
    }

    public void registerServiceProvider(ServiceProvider serviceProvider, ServiceProviderConfiguration providerConfiguration) {
        this.internalRegisterServiceProvider(serviceProvider, providerConfiguration);
    }

    public void registerOverrideServiceProvider(ServiceProvider serviceProvider, ServiceProviderConfiguration providerConfiguration) {
        this.internalRegisterServiceProviderAsOverride(serviceProvider, providerConfiguration);
    }

    public void registerExtendedConfiguration(Object extendedConfigObject) {
        this.extendedConfigurationObjects.add(extendedConfigObject);
    }

    public void attachDownstreamPassive(PassthroughServer passiveServer) {
        passiveServer.monitoringProducer.setUpstreamActive(this.monitoringProducer, passiveServer.serverProcess.getServerInfo());
        this.serverProcess.addDownstreamPassiveServerProcess(passiveServer.serverProcess);
    }

    public void detachDownstreamPassive(PassthroughServer passiveServer) {
        this.serverProcess.removeDownstreamPassiveServerProcess(passiveServer.serverProcess);
    }

    public void connectSavedClientsTo(PassthroughServer newActive) {
        for (Map.Entry<Long, PassthroughConnection> connection : this.savedClientConnections.entrySet()) {
            newActive.failOverReconnect(connection.getKey(), connection.getValue());
        }
        newActive.serverProcess.beginReceivingResends();
        for (Map.Entry<Long, PassthroughConnection> connection : this.savedClientConnections.entrySet()) {
            connection.getValue().finishReconnect();
        }
        newActive.serverProcess.endReceivingResends();
        if (!this.isActive) {
            this.savedClientConnections.clear();
        }
    }

    public void disconnectClients() {
        for (PassthroughConnection passthroughConnection : this.savedClientConnections.values()) {
            passthroughConnection.disconnect();
        }
    }

    private void failOverReconnect(Long connectionID, PassthroughConnection connection) {
        this.savedClientConnections.put(connectionID, connection);
        connection.startReconnect(this.serverProcess);
    }

    private void internalRegisterServiceProvider(ServiceProvider serviceProvider, ServiceProviderConfiguration providerConfiguration) {
        this.savedServiceProviderData.add(new ServiceProviderAndConfiguration(serviceProvider, providerConfiguration));
    }

    private void internalRegisterServiceProviderAsOverride(ServiceProvider serviceProvider, ServiceProviderConfiguration providerConfiguration) {
        this.savedServiceProviderData.add(new ServiceProviderAndConfiguration(serviceProvider, providerConfiguration, true));
    }

    @Override
    public void dump() {
        System.out.println("Connected passthrough clients:");
        for (PassthroughConnection connection : this.savedClientConnections.values()) {
            System.out.println("\t" + connection);
        }
        this.serverProcess.dump();
    }

    public void promoteToActive() {
        this.isActive = true;
        this.serverProcess.stop();
        this.monitoringProducer.didBecomeActive(this.serverProcess.getServerInfo());
        this.serverProcess.promoteToActive();
        this.serverProcess.resumeMessageProcessing();
    }

    public boolean isRunningProcess(PassthroughServerProcess victim) {
        return this.serverProcess == victim;
    }

    public Set<Long> getSavedClientConnections() {
        return this.savedClientConnections != null ? Collections.unmodifiableSet(this.savedClientConnections.keySet()) : Collections.emptySet();
    }

    public void setClusterControl(PassthroughClusterControl passthroughClusterControl) {
        this.passthroughClusterControl = passthroughClusterControl;
    }

    private void registerImplementationProvidedServices() {
        PassthroughCommunicatorServiceProvider communicatorServiceProvider = new PassthroughCommunicatorServiceProvider();
        this.serverProcess.registerImplementationProvidedServiceProvider(communicatorServiceProvider, null);
        PassthroughMessengerServiceProvider messengerServiceProvider = new PassthroughMessengerServiceProvider(this.serverProcess);
        this.serverProcess.registerImplementationProvidedServiceProvider(messengerServiceProvider, null);
        PassthroughPlatformServiceProvider passthroughPlatformServiceProvider = new PassthroughPlatformServiceProvider(this.passthroughClusterControl, this);
        this.serverProcess.registerImplementationProvidedServiceProvider(passthroughPlatformServiceProvider, null);
        this.monitoringProducer = new PassthroughMonitoringProducer(this.serverProcess);
        this.serverProcess.registerImplementationProvidedServiceProvider(this.monitoringProducer, null);
    }

    private void findClasspathBuiltinServices() {
        HashMap overrides = new HashMap();
        HashMap<String, ServiceProvider> providers = new HashMap<String, ServiceProvider>();
        ServiceLoader<ServiceProvider> loader = ServiceLoader.load(ServiceProvider.class);
        for (ServiceProvider provider : loader) {
            Object value;
            if (!provider.getClass().isAnnotationPresent(BuiltinService.class)) {
                System.err.println("service:" + provider.getClass().getName() + " not annotated with @BuiltinService.  The service will not be included");
                continue;
            }
            if (this.hasConfigurationForServiceProvider(provider) || this.hasOverrideProviderForTypes(provider)) continue;
            Class<?> type = provider.getClass();
            if (type.isAnnotationPresent(OverrideService.class)) {
                for (OverrideService overrideService : (OverrideService[])type.getAnnotationsByType(OverrideService.class)) {
                    value = overrideService.value();
                    String[] types = overrideService.types();
                    if (value != null && ((String)value).length() > 0) {
                        providers.remove(value);
                        overrides.put(value, type);
                    }
                    for (String typeName : types) {
                        providers.remove(typeName);
                        overrides.put(typeName, type);
                    }
                }
            }
            if (type.isAnnotationPresent(OverrideServiceType.class)) {
                for (OverrideService overrideService : (OverrideServiceType[])type.getAnnotationsByType(OverrideServiceType.class)) {
                    value = overrideService.value();
                    if (value == null) continue;
                    providers.remove(((Class)value).getName());
                    overrides.put(((Class)value).getName(), type);
                }
            }
            if (overrides.containsKey(type.getName())) continue;
            providers.put(type.getName(), provider);
        }
        providers.values().forEach(p -> this.serverProcess.registerServiceProvider((ServiceProvider)p, null));
    }

    private boolean hasOverrideProviderForTypes(ServiceProvider provider) {
        Collection types = provider.getProvidedServiceTypes();
        for (ServiceProviderAndConfiguration configuredServiceProvider : this.savedServiceProviderData) {
            Collection existingTypes;
            if (!configuredServiceProvider.override || !(existingTypes = configuredServiceProvider.serviceProvider.getProvidedServiceTypes()).containsAll(types)) continue;
            return true;
        }
        return false;
    }

    private boolean hasConfigurationForServiceProvider(ServiceProvider provider) {
        Class<?> providerClass = provider.getClass();
        for (ServiceProviderAndConfiguration configuredServiceProvider : this.savedServiceProviderData) {
            Class<?> existingServiceProviderClass = configuredServiceProvider.serviceProvider.getClass();
            if (!existingServiceProviderClass.equals(providerClass)) continue;
            return true;
        }
        return false;
    }

    private static class ServiceProviderAndConfiguration {
        public final ServiceProvider serviceProvider;
        public final ServiceProviderConfiguration providerConfiguration;
        public final boolean override;

        public ServiceProviderAndConfiguration(ServiceProvider serviceProvider, ServiceProviderConfiguration providerConfiguration) {
            this.serviceProvider = serviceProvider;
            this.providerConfiguration = providerConfiguration;
            this.override = false;
        }

        public ServiceProviderAndConfiguration(ServiceProvider serviceProvider, ServiceProviderConfiguration providerConfiguration, boolean override) {
            this.serviceProvider = serviceProvider;
            this.providerConfiguration = providerConfiguration;
            this.override = override;
        }
    }
}

