/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.terracotta.entity.EntityMessage;
import org.terracotta.passthrough.PassthroughConnection;

public class PassthroughRetirementManager {
    private final LinkedList<RetirementTuple> blockedTuples;
    private final Set<EntityMessage> blockingMessages;
    private final List<EntityMessage> blockCurrentMessageOn = new LinkedList<EntityMessage>();

    public PassthroughRetirementManager() {
        this.blockedTuples = new LinkedList();
        this.blockingMessages = Collections.newSetFromMap(new IdentityHashMap());
    }

    public synchronized void deferCurrentMessage(EntityMessage blockedOn) {
        this.blockCurrentMessageOn.add(blockedOn);
    }

    public synchronized boolean addRetirementTuple(RetirementTuple tuple) {
        boolean didBlockTuple = false;
        if (!this.blockedTuples.isEmpty() || !this.blockCurrentMessageOn.isEmpty()) {
            this.blockingMessages.addAll(this.blockCurrentMessageOn);
            tuple.blockedOn.addAll(this.blockCurrentMessageOn);
            this.blockedTuples.add(tuple);
            didBlockTuple = true;
            this.blockCurrentMessageOn.clear();
        }
        return didBlockTuple;
    }

    public synchronized List<RetirementTuple> retireableListAfterMessageDone(EntityMessage completedInternalOrNull) {
        if (null != completedInternalOrNull) {
            this.blockingMessages.remove(completedInternalOrNull);
            for (RetirementTuple blockedTuple : this.blockedTuples) {
                blockedTuple.blockedOn.remove(completedInternalOrNull);
            }
        }
        ArrayList<RetirementTuple> readyToRetire = new ArrayList<RetirementTuple>();
        Iterator blocked = this.blockedTuples.iterator();
        while (blocked.hasNext()) {
            RetirementTuple check = (RetirementTuple)blocked.next();
            if (!check.blockedOn.isEmpty()) break;
            blocked.remove();
            readyToRetire.add(check);
        }
        return readyToRetire;
    }

    public static class RetirementTuple {
        public Set<EntityMessage> blockedOn = Collections.newSetFromMap(new IdentityHashMap());
        public final PassthroughConnection sender;
        public final byte[] response;

        public RetirementTuple(PassthroughConnection sender, byte[] response) {
            this.sender = sender;
            this.response = response;
        }
    }
}

