/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.util.HashMap;
import java.util.Map;
import org.terracotta.passthrough.PassthroughEntityTuple;

public class PassthroughReferenceManager {
    private final Map<Long, PassthroughEntityTuple> references = new HashMap<Long, PassthroughEntityTuple>();

    public synchronized void reference(PassthroughEntityTuple entityTuple, long clientOriginID) {
        this.references.put(clientOriginID, entityTuple);
    }

    public synchronized boolean drop(PassthroughEntityTuple entityTuple, long clientOriginID) {
        boolean didRemove = false;
        if (entityTuple.equals(this.references.get(clientOriginID))) {
            this.references.remove(clientOriginID);
            didRemove = true;
        }
        return didRemove;
    }

    public synchronized boolean isReferenced(PassthroughEntityTuple entityTuple) {
        return this.references.values().contains(entityTuple);
    }
}

