/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.terracotta.monitoring.PlatformService;
import org.terracotta.monitoring.PlatformStopException;
import org.terracotta.passthrough.PassthroughClusterControl;
import org.terracotta.passthrough.PassthroughServer;

public class PassthroughPlatformService
implements PlatformService {
    private final PassthroughClusterControl passthroughClusterControl;
    private final PassthroughServer passthroughServer;

    public PassthroughPlatformService(PassthroughClusterControl passthroughClusterControl, PassthroughServer passthroughServer) {
        this.passthroughClusterControl = passthroughClusterControl;
        this.passthroughServer = passthroughServer;
    }

    public void dumpPlatformState() {
        this.passthroughServer.dump();
    }

    public void stopPlatform() {
        this.stopPlatform(PlatformService.RestartMode.STOP_ONLY);
    }

    public InputStream getPlatformConfiguration() {
        return new ByteArrayInputStream(new byte[0]);
    }

    public void stopPlatformIfPassive(PlatformService.RestartMode restartMode) throws PlatformStopException {
        this.passthroughClusterControl.terminateIfPassive(this.passthroughServer, restartMode);
    }

    public void stopPlatformIfActive(PlatformService.RestartMode restartMode) throws PlatformStopException {
        this.passthroughClusterControl.terminateIfActive(this.passthroughServer, restartMode);
    }

    public void stopPlatform(PlatformService.RestartMode restartMode) {
        this.passthroughClusterControl.terminate(this.passthroughServer, restartMode);
    }

    public void fatalError(String string) {
        this.passthroughServer.stop();
    }

    public long uptime() {
        return 0L;
    }
}

