/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Vector;
import org.terracotta.entity.PlatformConfiguration;
import org.terracotta.passthrough.Assert;

public class PassthroughPlatformConfiguration
implements PlatformConfiguration,
AutoCloseable {
    private final int port;
    private final String serverName;
    private final Collection<Object> extendedConfigurationObjects;

    public PassthroughPlatformConfiguration(String serverName, int port, Collection<Object> extendedConfigurationObjects) {
        this.serverName = serverName;
        this.port = port;
        this.extendedConfigurationObjects = extendedConfigurationObjects;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getHost() {
        return this.serverName;
    }

    public int getTsaPort() {
        return this.port;
    }

    public <T> Collection<T> getExtendedConfiguration(Class<T> type) {
        Vector<T> filtered = new Vector<T>();
        for (Object instance : this.extendedConfigurationObjects) {
            if (!type.isInstance(instance)) continue;
            filtered.add(type.cast(instance));
        }
        return filtered;
    }

    @Override
    public void close() {
        for (Object instance : this.extendedConfigurationObjects) {
            if (instance instanceof Closeable) {
                try {
                    ((Closeable)instance).close();
                }
                catch (IOException ioe) {
                    Assert.unexpected(ioe);
                }
                continue;
            }
            if (!(instance instanceof AutoCloseable)) continue;
            try {
                ((AutoCloseable)instance).close();
            }
            catch (Exception e) {
                Assert.unexpected(e);
            }
        }
    }
}

