/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.terracotta.entity.PlatformConfiguration;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceProvider;
import org.terracotta.entity.ServiceProviderCleanupException;
import org.terracotta.entity.ServiceProviderConfiguration;
import org.terracotta.passthrough.PassthroughNullPlatformPersistentStorage;
import org.terracotta.persistence.IPlatformPersistence;

public class PassthroughNullPlatformStorageServiceProvider
implements ServiceProvider {
    private final Map<Long, PassthroughNullPlatformPersistentStorage> providers = new HashMap<Long, PassthroughNullPlatformPersistentStorage>();

    public boolean initialize(ServiceProviderConfiguration serviceProviderConfiguration, PlatformConfiguration platformConfiguration) {
        return true;
    }

    public synchronized <T> T getService(long consumerID, ServiceConfiguration<T> serviceConfiguration) {
        PassthroughNullPlatformPersistentStorage storage = this.providers.get(consumerID);
        if (null == storage) {
            storage = new PassthroughNullPlatformPersistentStorage();
            this.providers.put(consumerID, storage);
        }
        return serviceConfiguration.getServiceType().cast(storage);
    }

    public Collection<Class<?>> getProvidedServiceTypes() {
        HashSet set = new HashSet();
        set.add(IPlatformPersistence.class);
        return set;
    }

    public synchronized void close() throws IOException {
        this.providers.clear();
    }

    public synchronized void prepareForSynchronization() throws ServiceProviderCleanupException {
        this.providers.clear();
    }
}

