/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.terracotta.persistence.IPlatformPersistence;

public class PassthroughNullPlatformPersistentStorage
implements IPlatformPersistence {
    final Map<String, Serializable> nameToDataMap = new HashMap<String, Serializable>();
    final Map<Long, List<IPlatformPersistence.SequenceTuple>> fastSequenceCache = new HashMap<Long, List<IPlatformPersistence.SequenceTuple>>();

    public synchronized Serializable loadDataElement(String name) throws IOException {
        return this.nameToDataMap.get(name);
    }

    public synchronized Serializable loadDataElementInLoader(String name, ClassLoader loader) throws IOException {
        return this.nameToDataMap.get(name);
    }

    public synchronized void storeDataElement(String name, Serializable element) throws IOException {
        if (null == element) {
            this.nameToDataMap.remove(name);
        } else {
            this.nameToDataMap.put(name, element);
        }
    }

    public synchronized Future<Void> fastStoreSequence(long sequenceIndex, IPlatformPersistence.SequenceTuple newEntry, long oldestValidSequenceID) {
        List<IPlatformPersistence.SequenceTuple> oldSequence = this.fastSequenceCache.get(sequenceIndex);
        ArrayList<IPlatformPersistence.SequenceTuple> newSequence = new ArrayList<IPlatformPersistence.SequenceTuple>();
        if (null != oldSequence) {
            for (IPlatformPersistence.SequenceTuple tuple : oldSequence) {
                if (tuple.localSequenceID < oldestValidSequenceID) continue;
                newSequence.add(tuple);
            }
            newSequence.add(newEntry);
        }
        this.fastSequenceCache.put(sequenceIndex, newSequence);
        return new Future<Void>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public Void get() throws InterruptedException, ExecutionException {
                return null;
            }

            @Override
            public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return null;
            }
        };
    }

    public synchronized List<IPlatformPersistence.SequenceTuple> loadSequence(long sequenceIndex) {
        return this.fastSequenceCache.get(sequenceIndex);
    }

    public synchronized void deleteSequence(long sequenceIndex) {
        this.fastSequenceCache.remove(sequenceIndex);
    }
}

