/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceException;
import org.terracotta.monitoring.IMonitoringProducer;
import org.terracotta.monitoring.IStripeMonitoring;
import org.terracotta.monitoring.PlatformServer;
import org.terracotta.passthrough.Assert;
import org.terracotta.passthrough.PassthroughImplementationProvidedServiceProvider;
import org.terracotta.passthrough.PassthroughServerProcess;
import org.terracotta.passthrough.PassthroughServiceRegistry;

public class PassthroughMonitoringProducer
implements PassthroughImplementationProvidedServiceProvider {
    private final PassthroughServerProcess serverProcess;
    private Map<Long, CacheNode> cachedTreeRoot;
    private PlatformServer serverInfoToken;
    private PassthroughMonitoringProducer activeMonitoringProducer;

    public PassthroughMonitoringProducer(PassthroughServerProcess serverProcess) {
        this.serverProcess = serverProcess;
        this.cachedTreeRoot = new HashMap<Long, CacheNode>();
    }

    public void didBecomeActive(PlatformServer serverInfo) {
        Assert.assertTrue(null != serverInfo);
        this.serverInfoToken = serverInfo;
        IStripeMonitoring platformMonitoring = this.getUnderlyingService(null, null, 0L, null);
        if (null != platformMonitoring) {
            platformMonitoring.serverDidBecomeActive(this.serverInfoToken);
            for (Map.Entry<Long, CacheNode> entry : this.cachedTreeRoot.entrySet()) {
                IStripeMonitoring entityMonitoring = this.getUnderlyingService(null, null, entry.getKey(), null);
                Assert.assertTrue(null != entityMonitoring);
                this.walkCacheChildren(entityMonitoring, new String[0], entry.getValue().children);
            }
        }
        this.cachedTreeRoot = null;
    }

    @Override
    public <T> T getService(String entityClassName, String entityName, final long consumerID, PassthroughImplementationProvidedServiceProvider.DeferredEntityContainer container, ServiceConfiguration<T> configuration) throws ServiceException {
        IStripeMonitoring underlying;
        T service = null;
        Class serviceType = configuration.getServiceType();
        if (serviceType.equals(IMonitoringProducer.class) && null != (underlying = this.getUnderlyingService(entityClassName, entityName, consumerID, container))) {
            if (null != this.cachedTreeRoot && !this.cachedTreeRoot.containsKey(consumerID)) {
                this.cachedTreeRoot.put(consumerID, new CacheNode(null));
            }
            service = serviceType.cast(new IMonitoringProducer(){

                public boolean addNode(String[] parents, String name, Serializable value) {
                    return PassthroughMonitoringProducer.this.addNodeFromShim(consumerID, underlying, parents, name, value);
                }

                public boolean removeNode(String[] parents, String name) {
                    return PassthroughMonitoringProducer.this.removeNodeFromShim(consumerID, underlying, parents, name);
                }

                public void pushBestEffortsData(String name, Serializable data) {
                    PassthroughMonitoringProducer.this.pushBestEffortsFromShim(consumerID, underlying, name, data);
                }
            });
        }
        return service;
    }

    @Override
    public Collection<Class<?>> getProvidedServiceTypes() {
        HashSet set = new HashSet();
        set.add(IMonitoringProducer.class);
        return set;
    }

    public synchronized void setUpstreamActive(PassthroughMonitoringProducer activeMonitoringProducer, PlatformServer passiveServerInfoToken) {
        this.activeMonitoringProducer = activeMonitoringProducer;
        this.serverInfoToken = passiveServerInfoToken;
        this.activeMonitoringProducer.passiveDidJoinCluster(this.serverInfoToken);
        for (Map.Entry<Long, CacheNode> entry : this.cachedTreeRoot.entrySet()) {
            long consumerID = entry.getKey();
            this.walkCacheChildrenToActive(consumerID, new String[0], entry.getValue().children);
        }
    }

    public synchronized void serverDidStop() {
        if (null != this.activeMonitoringProducer) {
            this.activeMonitoringProducer.passiveDidLeaveCluster(this.serverInfoToken);
        }
    }

    private IStripeMonitoring getUnderlyingService(String entityClassName, String entityName, long consumerID, PassthroughImplementationProvidedServiceProvider.DeferredEntityContainer container) {
        PassthroughServiceRegistry registry = this.serverProcess.createServiceRegistryForInternalConsumer(entityClassName, entityName, consumerID, container);
        final Collection underlying = registry.getServices(() -> IStripeMonitoring.class);
        return new IStripeMonitoring(){

            public void serverDidBecomeActive(PlatformServer ps) {
                underlying.forEach(m -> m.serverDidBecomeActive(ps));
            }

            public void serverDidJoinStripe(PlatformServer ps) {
                underlying.forEach(m -> m.serverDidJoinStripe(ps));
            }

            public void serverDidLeaveStripe(PlatformServer ps) {
                underlying.forEach(m -> m.serverDidLeaveStripe(ps));
            }

            public boolean addNode(PlatformServer ps, String[] path, String name, Serializable value) {
                return underlying.stream().map(m -> m.addNode(ps, path, name, value)).reduce(Boolean.TRUE, Boolean::logicalAnd);
            }

            public boolean removeNode(PlatformServer ps, String[] path, String name) {
                return underlying.stream().map(m -> m.removeNode(ps, path, name)).reduce(Boolean.TRUE, Boolean::logicalAnd);
            }

            public void pushBestEffortsData(PlatformServer ps, String path, Serializable value) {
                underlying.forEach(m -> m.pushBestEffortsData(ps, path, value));
            }
        };
    }

    private synchronized boolean addNodeFromShim(long consumerID, IStripeMonitoring underlyingCollector, String[] parents, String name, Serializable value) {
        boolean didStore = false;
        if (null != this.cachedTreeRoot) {
            CacheNode parentNode = this.findParent(consumerID, parents);
            if (null != parentNode) {
                parentNode.children.put(name, new CacheNode(value));
                didStore = true;
            }
            if (null != this.activeMonitoringProducer) {
                this.activeMonitoringProducer.addNodeFromPassive(this.serverInfoToken, consumerID, parents, name, value);
            }
        } else {
            didStore = underlyingCollector.addNode(this.serverInfoToken, parents, name, value);
        }
        return didStore;
    }

    private synchronized boolean removeNodeFromShim(long consumerID, IStripeMonitoring underlyingCollector, String[] parents, String name) {
        boolean didRemove = false;
        if (null != this.cachedTreeRoot) {
            CacheNode parentNode = this.findParent(consumerID, parents);
            if (null != parentNode) {
                CacheNode removed = parentNode.children.remove(name);
                boolean bl = didRemove = null != removed;
            }
            if (null != this.activeMonitoringProducer) {
                this.activeMonitoringProducer.removeNodeFromPassive(this.serverInfoToken, consumerID, parents, name);
            }
        } else {
            didRemove = underlyingCollector.removeNode(this.serverInfoToken, parents, name);
        }
        return didRemove;
    }

    private synchronized void pushBestEffortsFromShim(long consumerID, IStripeMonitoring underlyingCollector, String name, Serializable data) {
        if (null != this.cachedTreeRoot) {
            if (null != this.activeMonitoringProducer) {
                this.activeMonitoringProducer.pushBestEffortsFromPassive(this.serverInfoToken, consumerID, name, data);
            }
        } else {
            underlyingCollector.pushBestEffortsData(this.serverInfoToken, name, data);
        }
    }

    private CacheNode findParent(long consumerID, String[] parents) {
        CacheNode oneNode = this.cachedTreeRoot.get(consumerID);
        for (int i = 0; null != oneNode && i < parents.length; ++i) {
            oneNode = oneNode.children.get(parents[i]);
        }
        CacheNode parentNode = null;
        if (null != oneNode) {
            parentNode = oneNode;
        }
        return parentNode;
    }

    private void walkCacheChildren(IStripeMonitoring entityMonitoring, String[] parents, Map<String, CacheNode> nodeChildren) {
        for (Map.Entry<String, CacheNode> child : nodeChildren.entrySet()) {
            this.walkCacheNode(entityMonitoring, parents, child.getKey(), child.getValue());
        }
    }

    private void walkCacheNode(IStripeMonitoring entityMonitoring, String[] parents, String nodeName, CacheNode node) {
        Assert.assertTrue(null != nodeName);
        entityMonitoring.addNode(this.serverInfoToken, parents, nodeName, node.data);
        String[] newParents = new String[parents.length + 1];
        System.arraycopy(parents, 0, newParents, 0, parents.length);
        newParents[parents.length] = nodeName;
        this.walkCacheChildren(entityMonitoring, newParents, node.children);
    }

    private void walkCacheChildrenToActive(long consumerID, String[] parents, Map<String, CacheNode> nodeChildren) {
        for (Map.Entry<String, CacheNode> child : nodeChildren.entrySet()) {
            this.walkCacheNodeToActive(consumerID, parents, child.getKey(), child.getValue());
        }
    }

    private void walkCacheNodeToActive(long consumerID, String[] parents, String nodeName, CacheNode node) {
        Assert.assertTrue(null != nodeName);
        this.activeMonitoringProducer.addNodeFromPassive(this.serverInfoToken, consumerID, parents, nodeName, node.data);
        String[] newParents = new String[parents.length + 1];
        System.arraycopy(parents, 0, newParents, 0, parents.length);
        newParents[parents.length] = nodeName;
        this.walkCacheChildrenToActive(consumerID, newParents, node.children);
    }

    private synchronized void passiveDidJoinCluster(PlatformServer passiveInfo) {
        IStripeMonitoring platformMonitoring = this.getUnderlyingService(null, null, 0L, null);
        if (null != platformMonitoring) {
            platformMonitoring.serverDidJoinStripe(passiveInfo);
        }
    }

    private synchronized void passiveDidLeaveCluster(PlatformServer passiveInfo) {
        IStripeMonitoring platformMonitoring = this.getUnderlyingService(null, null, 0L, null);
        if (null != platformMonitoring) {
            platformMonitoring.serverDidLeaveStripe(passiveInfo);
        }
    }

    private synchronized void addNodeFromPassive(PlatformServer passiveInfo, long consumerID, String[] parents, String nodeName, Serializable nodeData) {
        IStripeMonitoring platformMonitoring = this.getUnderlyingService(null, null, consumerID, null);
        if (null != platformMonitoring) {
            platformMonitoring.addNode(passiveInfo, parents, nodeName, nodeData);
        }
    }

    private synchronized void removeNodeFromPassive(PlatformServer passiveInfo, long consumerID, String[] parents, String nodeName) {
        IStripeMonitoring platformMonitoring = this.getUnderlyingService(null, null, consumerID, null);
        if (null != platformMonitoring) {
            platformMonitoring.removeNode(passiveInfo, parents, nodeName);
        }
    }

    private synchronized void pushBestEffortsFromPassive(PlatformServer passiveInfo, long consumerID, String name, Serializable data) {
        IStripeMonitoring platformMonitoring = this.getUnderlyingService(null, null, consumerID, null);
        if (null != platformMonitoring) {
            platformMonitoring.pushBestEffortsData(passiveInfo, name, data);
        }
    }

    private static class CacheNode {
        public final Serializable data;
        public final Map<String, CacheNode> children;

        public CacheNode(Serializable data) {
            this.data = data;
            this.children = new HashMap<String, CacheNode>();
        }
    }
}

