/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.util.concurrent.Executor;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.InvokeMonitor;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.exception.EntityException;

public class PassthroughMonitor<R extends EntityResponse> {
    private final MessageCodec<?, R> codec;
    private final InvokeMonitor<R> monitor;
    private final Executor executor;

    public PassthroughMonitor(MessageCodec<?, R> codec, InvokeMonitor<R> monitor, Executor e) {
        this.codec = codec;
        this.monitor = monitor;
        this.executor = e;
    }

    public void sendResponse(byte[] data) {
        EntityResponse response = null;
        try {
            response = this.codec.decodeResponse(data);
        }
        catch (MessageCodecException codec) {
            throw new RuntimeException(codec);
        }
        EntityResponse lock = response;
        if (this.monitor != null) {
            if (this.executor != null) {
                this.executor.execute(() -> this.monitor.accept((Object)lock));
            } else {
                this.monitor.accept((Object)lock);
            }
        }
    }

    public void sendException(EntityException exp) {
        if (this.monitor != null) {
            if (this.executor != null) {
                this.executor.execute(() -> this.monitor.exception(exp));
            } else {
                this.monitor.exception(exp);
            }
        }
    }
}

