/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Supplier;
import org.terracotta.entity.IEntityMessenger;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.passthrough.Assert;
import org.terracotta.passthrough.PassthroughImplementationProvidedServiceProvider;
import org.terracotta.passthrough.PassthroughMessengerService;
import org.terracotta.passthrough.PassthroughServerProcess;
import org.terracotta.passthrough.PassthroughTimerThread;

public class PassthroughMessengerServiceProvider
implements PassthroughImplementationProvidedServiceProvider,
Closeable {
    private final PassthroughTimerThread timerThread = new PassthroughTimerThread();
    private final PassthroughServerProcess passthroughServerProcess;

    public PassthroughMessengerServiceProvider(PassthroughServerProcess passthroughServerProcess) {
        this.passthroughServerProcess = passthroughServerProcess;
        this.timerThread.setName("PassthroughTimerThread");
        this.timerThread.start();
    }

    @Override
    public <T> T getService(String entityClassName, String entityName, long consumerID, PassthroughImplementationProvidedServiceProvider.DeferredEntityContainer container, ServiceConfiguration<T> configuration) {
        boolean chain = false;
        if (configuration instanceof Supplier) {
            chain = (Boolean)((Supplier)configuration).get();
        }
        return configuration.getServiceType().cast(new PassthroughMessengerService(this.timerThread, this.passthroughServerProcess, container, chain, entityClassName, entityName));
    }

    @Override
    public Collection<Class<?>> getProvidedServiceTypes() {
        HashSet set = new HashSet();
        set.add(IEntityMessenger.class);
        return set;
    }

    @Override
    public void close() throws IOException {
        this.timerThread.shutdown();
        try {
            this.timerThread.join();
        }
        catch (InterruptedException e) {
            Assert.unexpected(e);
        }
    }
}

