/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.function.Consumer;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.ExplicitRetirementHandle;
import org.terracotta.entity.IEntityMessenger;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.exception.EntityException;
import org.terracotta.passthrough.PassthroughImplementationProvidedServiceProvider;
import org.terracotta.passthrough.PassthroughMessage;
import org.terracotta.passthrough.PassthroughMessageCodec;
import org.terracotta.passthrough.PassthroughRetirementManager;
import org.terracotta.passthrough.PassthroughServerProcess;
import org.terracotta.passthrough.PassthroughTimerThread;

public class PassthroughMessengerService
implements IEntityMessenger<EntityMessage, EntityResponse> {
    private final PassthroughServerProcess passthroughServerProcess;
    private final PassthroughRetirementManager retirementManager;
    private final PassthroughImplementationProvidedServiceProvider.DeferredEntityContainer entityContainer;
    private final String entityClassName;
    private final String entityName;

    public PassthroughMessengerService(PassthroughTimerThread timerThread, PassthroughServerProcess passthroughServerProcess, PassthroughImplementationProvidedServiceProvider.DeferredEntityContainer entityContainer, boolean chain, String entityClassName, String entityName) {
        this.passthroughServerProcess = passthroughServerProcess;
        this.retirementManager = passthroughServerProcess.getRetirementManager();
        this.entityContainer = entityContainer;
        this.entityClassName = entityClassName;
        this.entityName = entityName;
    }

    public void destroySelf() {
        try {
            this.passthroughServerProcess.destroy(this.entityClassName, this.entityName);
        }
        catch (EntityException entityException) {
            // empty catch block
        }
    }

    public void create(String entityClassName, String entityName, long version, byte[] config) {
        try {
            this.passthroughServerProcess.create(entityClassName, entityName, version, config);
        }
        catch (EntityException entityException) {
            // empty catch block
        }
    }

    public void reconfigureSelf(byte[] config) {
        try {
            this.passthroughServerProcess.reconfigure(this.entityClassName, this.entityName, 1L, config);
        }
        catch (EntityException entityException) {
            // empty catch block
        }
    }

    public void messageSelf(EntityMessage message) throws MessageCodecException {
        PassthroughMessage passthroughMessage = this.makePassthroughMessage(message);
        this.passthroughServerProcess.sendMessageToActiveFromInsideActive(message, passthroughMessage, null);
    }

    public ExplicitRetirementHandle deferRetirement(final String tag, EntityMessage originalMessageToDefer, final EntityMessage futureMessage) {
        try {
            final PassthroughMessage futurePassThroughMessage = this.makePassthroughMessage(futureMessage);
            this.retirementManager.deferCurrentMessage(futureMessage);
            return new ExplicitRetirementHandle(){

                public String getTag() {
                    return tag;
                }

                public void release(Consumer consumer) throws MessageCodecException {
                    PassthroughMessengerService.this.passthroughServerProcess.sendMessageToActiveFromInsideActive(futureMessage, futurePassThroughMessage, null);
                }

                public void release() throws MessageCodecException {
                    PassthroughMessengerService.this.passthroughServerProcess.sendMessageToActiveFromInsideActive(futureMessage, futurePassThroughMessage, null);
                }
            };
        }
        catch (MessageCodecException e) {
            System.err.println("Codec error in explicit retirement: " + (Object)((Object)e));
            throw new RuntimeException(e);
        }
    }

    public void messageSelfAndDeferRetirement(EntityMessage originalMessageToDefer, EntityMessage newMessageToSchedule) throws MessageCodecException {
        this.retirementManager.deferCurrentMessage(newMessageToSchedule);
        this.passthroughServerProcess.sendMessageToActiveFromInsideActive(newMessageToSchedule, this.makePassthroughMessage(newMessageToSchedule), null);
    }

    public void messageSelf(EntityMessage message, Consumer<IEntityMessenger.MessageResponse<EntityResponse>> response) throws MessageCodecException {
        this.passthroughServerProcess.sendMessageToActiveFromInsideActive(message, this.makePassthroughMessage(message), this.queueForComplete(response));
    }

    private Consumer<PassthroughMessage> queueForComplete(Consumer<IEntityMessenger.MessageResponse<EntityResponse>> response) {
        if (response != null) {
            return msg -> {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(bos);
                    msg.populateStream(dos);
                    dos.close();
                    ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                    DataInputStream dis = new DataInputStream(bis);
                    switch (msg.type) {
                        case MONITOR_MESSAGE: 
                        case MONITOR_EXCEPTION: 
                        case COMPLETE_FROM_SERVER: 
                        case EXCEPTION_FROM_SERVER: {
                            final boolean success = msg.type != PassthroughMessage.Type.MONITOR_EXCEPTION && msg.type != PassthroughMessage.Type.EXCEPTION_FROM_SERVER;
                            int len = dis.readInt();
                            final byte[] data = new byte[len];
                            dis.readFully(data);
                            response.accept(new IEntityMessenger.MessageResponse<EntityResponse>(){

                                public boolean wasExceptionThrown() {
                                    return success;
                                }

                                public Exception getException() {
                                    return !success ? PassthroughMessageCodec.deserializeExceptionFromArray(data) : null;
                                }

                                public EntityResponse getResponse() {
                                    try {
                                        return success ? ((PassthroughMessengerService)PassthroughMessengerService.this).entityContainer.codec.decodeResponse(data) : null;
                                    }
                                    catch (MessageCodecException io) {
                                        throw new RuntimeException(io);
                                    }
                                }
                            });
                        }
                    }
                }
                catch (IOException io) {
                    throw new RuntimeException(io);
                }
            };
        }
        return null;
    }

    public void messageSelfAndDeferRetirement(EntityMessage originalMessageToDefer, EntityMessage newMessageToSchedule, Consumer response) throws MessageCodecException {
        this.retirementManager.deferCurrentMessage(newMessageToSchedule);
        PassthroughMessage passthroughMessage = this.makePassthroughMessage(newMessageToSchedule);
        this.passthroughServerProcess.sendMessageToActiveFromInsideActive(newMessageToSchedule, passthroughMessage, this.queueForComplete(response));
    }

    private PassthroughMessage makePassthroughMessage(EntityMessage message) throws MessageCodecException {
        MessageCodec<?, ?> codec = this.entityContainer.codec;
        byte[] serializedMessage = codec.encodeMessage(message);
        long clientInstanceID = 0L;
        boolean shouldReplicateToPassives = true;
        PassthroughMessage passthroughMessage = PassthroughMessageCodec.createInvokeMessage(this.entityClassName, this.entityName, clientInstanceID, serializedMessage, shouldReplicateToPassives);
        return passthroughMessage;
    }
}

