/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.terracotta.exception.EntityException;
import org.terracotta.passthrough.Assert;
import org.terracotta.passthrough.PassthroughMessage;

public class PassthroughMessageCodec {
    public static PassthroughMessage createFetchMessage(final String entityClassName, final String entityName, final long clientInstanceID, final long version) {
        boolean shouldReplicateToPassives = false;
        return new PassthroughMessage(PassthroughMessage.Type.FETCH_ENTITY, shouldReplicateToPassives){

            @Override
            protected void populateStream(DataOutputStream output) throws IOException {
                output.writeUTF(entityClassName);
                output.writeUTF(entityName);
                output.writeLong(clientInstanceID);
                output.writeLong(version);
            }
        };
    }

    public static PassthroughMessage createReleaseMessage(final String entityClassName, final String entityName, final long clientInstanceID) {
        boolean shouldReplicateToPassives = true;
        return new PassthroughMessage(PassthroughMessage.Type.RELEASE_ENTITY, shouldReplicateToPassives){

            @Override
            protected void populateStream(DataOutputStream output) throws IOException {
                output.writeUTF(entityClassName);
                output.writeUTF(entityName);
                output.writeLong(clientInstanceID);
            }
        };
    }

    public static PassthroughMessage createUnexpectedReleaseMessage(final String entityClassName, final String entityName, final long clientInstanceID) {
        boolean shouldReplicateToPassives = true;
        return new PassthroughMessage(PassthroughMessage.Type.UNEXPECTED_RELEASE, shouldReplicateToPassives){

            @Override
            protected void populateStream(DataOutputStream output) throws IOException {
                output.writeUTF(entityClassName);
                output.writeUTF(entityName);
                output.writeLong(clientInstanceID);
            }
        };
    }

    public static PassthroughMessage createExistsMessage(final String entityClassName, final String entityName, final long version) {
        boolean shouldReplicateToPassives = false;
        return new PassthroughMessage(PassthroughMessage.Type.DOES_ENTITY_EXIST, shouldReplicateToPassives){

            @Override
            protected void populateStream(DataOutputStream output) throws IOException {
                output.writeUTF(entityClassName);
                output.writeUTF(entityName);
                output.writeLong(version);
            }
        };
    }

    public static PassthroughMessage createDestroyMessage(final String entityClassName, final String entityName) {
        boolean shouldReplicateToPassives = true;
        return new PassthroughMessage(PassthroughMessage.Type.DESTROY_ENTITY, shouldReplicateToPassives){

            @Override
            protected void populateStream(DataOutputStream output) throws IOException {
                output.writeUTF(entityClassName);
                output.writeUTF(entityName);
            }
        };
    }

    public static PassthroughMessage createCreateMessage(final String entityClassName, final String entityName, final long version, final byte[] serializedConfiguration) {
        boolean shouldReplicateToPassives = true;
        return new PassthroughMessage(PassthroughMessage.Type.CREATE_ENTITY, shouldReplicateToPassives){

            @Override
            protected void populateStream(DataOutputStream output) throws IOException {
                output.writeUTF(entityClassName);
                output.writeUTF(entityName);
                output.writeLong(version);
                output.writeInt(serializedConfiguration.length);
                output.write(serializedConfiguration);
            }
        };
    }

    public static PassthroughMessage createReconfigureMessage(final String entityClassName, final String entityName, final long version, final byte[] serializedConfiguration) {
        boolean shouldReplicateToPassives = true;
        return new PassthroughMessage(PassthroughMessage.Type.RECONFIGURE_ENTITY, shouldReplicateToPassives){

            @Override
            protected void populateStream(DataOutputStream output) throws IOException {
                output.writeUTF(entityClassName);
                output.writeUTF(entityName);
                output.writeLong(version);
                output.writeInt(serializedConfiguration.length);
                output.write(serializedConfiguration);
            }
        };
    }

    public static PassthroughMessage createInvokeMessage(final String entityClassName, final String entityName, final long clientInstanceID, final byte[] payload, boolean shouldReplicateToPassives) {
        return new PassthroughMessage(PassthroughMessage.Type.INVOKE_ON_SERVER, shouldReplicateToPassives){

            @Override
            protected void populateStream(DataOutputStream output) throws IOException {
                output.writeUTF(entityClassName);
                output.writeUTF(entityName);
                output.writeLong(clientInstanceID);
                output.writeInt(payload.length);
                output.write(payload);
            }
        };
    }

    public static PassthroughMessage createAckMessage() {
        boolean shouldReplicateToPassives = false;
        return new PassthroughMessage(PassthroughMessage.Type.ACK_FROM_SERVER, shouldReplicateToPassives){

            @Override
            protected void populateStream(DataOutputStream output) throws IOException {
                output.writeInt(PassthroughMessage.Type.ACK_FROM_SERVER.ordinal());
            }
        };
    }

    public static PassthroughMessage createMonitorMessage(final byte[] response, final EntityException error) {
        boolean shouldReplicateToPassives = false;
        final boolean isSuccess = null == error;
        return new PassthroughMessage(isSuccess ? PassthroughMessage.Type.MONITOR_MESSAGE : PassthroughMessage.Type.MONITOR_EXCEPTION, shouldReplicateToPassives){

            @Override
            protected void populateStream(DataOutputStream output) throws IOException {
                if (isSuccess) {
                    if (null != response) {
                        output.writeInt(response.length);
                        output.write(response);
                    } else {
                        output.writeInt(-1);
                    }
                } else {
                    byte[] serializedException = PassthroughMessageCodec.serializeExceptionToArray(error);
                    output.writeInt(serializedException.length);
                    output.write(serializedException);
                }
            }
        };
    }

    public static PassthroughMessage createCompleteMessage(final byte[] response, final EntityException error) {
        boolean shouldReplicateToPassives = false;
        final boolean isSuccess = null == error;
        return new PassthroughMessage(isSuccess ? PassthroughMessage.Type.COMPLETE_FROM_SERVER : PassthroughMessage.Type.EXCEPTION_FROM_SERVER, shouldReplicateToPassives){

            @Override
            protected void populateStream(DataOutputStream output) throws IOException {
                if (isSuccess) {
                    if (null != response) {
                        output.writeInt(response.length);
                        output.write(response);
                    } else {
                        output.writeInt(-1);
                    }
                } else {
                    byte[] serializedException = PassthroughMessageCodec.serializeExceptionToArray(error);
                    output.writeInt(serializedException.length);
                    output.write(serializedException);
                }
            }
        };
    }

    public static PassthroughMessage createRetireMessage() {
        boolean shouldReplicateToPassives = false;
        return new PassthroughMessage(PassthroughMessage.Type.RETIRE_FROM_SERVER, shouldReplicateToPassives){

            @Override
            protected void populateStream(DataOutputStream output) throws IOException {
                output.writeInt(PassthroughMessage.Type.RETIRE_FROM_SERVER.ordinal());
            }
        };
    }

    public static PassthroughMessage createMessageToClient(final long clientInstanceID, final byte[] payload) {
        boolean shouldReplicateToPassives = false;
        return new PassthroughMessage(PassthroughMessage.Type.INVOKE_ON_CLIENT, shouldReplicateToPassives){

            @Override
            protected void populateStream(DataOutputStream output) throws IOException {
                output.writeLong(clientInstanceID);
                output.writeInt(payload.length);
                output.write(payload);
            }
        };
    }

    public static PassthroughMessage createReconnectMessage(final String entityClassName, final String entityName, final long clientInstanceID, final byte[] extendedData) {
        Assert.assertTrue(null != extendedData);
        boolean shouldReplicateToPassives = false;
        return new PassthroughMessage(PassthroughMessage.Type.RECONNECT, shouldReplicateToPassives){

            @Override
            protected void populateStream(DataOutputStream output) throws IOException {
                output.writeUTF(entityClassName);
                output.writeUTF(entityName);
                output.writeLong(clientInstanceID);
                output.writeInt(extendedData.length);
                output.write(extendedData);
            }
        };
    }

    public static PassthroughMessage createSyncEntityStartMessage(final String entityClassName, final String entityName, final long version, final byte[] serializedConfiguration) {
        boolean shouldReplicateToPassives = false;
        return new PassthroughMessage(PassthroughMessage.Type.SYNC_ENTITY_START, shouldReplicateToPassives){

            @Override
            protected void populateStream(DataOutputStream output) throws IOException {
                output.writeUTF(entityClassName);
                output.writeUTF(entityName);
                output.writeLong(version);
                output.writeInt(serializedConfiguration.length);
                output.write(serializedConfiguration);
            }
        };
    }

    public static PassthroughMessage createSyncEntityEndMessage(final String entityClassName, final String entityName) {
        boolean shouldReplicateToPassives = false;
        return new PassthroughMessage(PassthroughMessage.Type.SYNC_ENTITY_END, shouldReplicateToPassives){

            @Override
            protected void populateStream(DataOutputStream output) throws IOException {
                output.writeUTF(entityClassName);
                output.writeUTF(entityName);
            }
        };
    }

    public static PassthroughMessage createSyncEntityKeyStartMessage(final String entityClassName, final String entityName, final int concurrencyKey) {
        boolean shouldReplicateToPassives = false;
        return new PassthroughMessage(PassthroughMessage.Type.SYNC_ENTITY_KEY_START, shouldReplicateToPassives){

            @Override
            protected void populateStream(DataOutputStream output) throws IOException {
                output.writeUTF(entityClassName);
                output.writeUTF(entityName);
                output.writeInt(concurrencyKey);
            }
        };
    }

    public static PassthroughMessage createSyncEntityKeyEndMessage(final String entityClassName, final String entityName, final int concurrencyKey) {
        boolean shouldReplicateToPassives = false;
        return new PassthroughMessage(PassthroughMessage.Type.SYNC_ENTITY_KEY_END, shouldReplicateToPassives){

            @Override
            protected void populateStream(DataOutputStream output) throws IOException {
                output.writeUTF(entityClassName);
                output.writeUTF(entityName);
                output.writeInt(concurrencyKey);
            }
        };
    }

    public static PassthroughMessage createSyncPayloadMessage(final String entityClassName, final String entityName, final int concurrencyKey, final byte[] payload) {
        boolean shouldReplicateToPassives = false;
        return new PassthroughMessage(PassthroughMessage.Type.SYNC_ENTITY_PAYLOAD, shouldReplicateToPassives){

            @Override
            protected void populateStream(DataOutputStream output) throws IOException {
                output.writeUTF(entityClassName);
                output.writeUTF(entityName);
                output.writeInt(concurrencyKey);
                output.writeInt(payload.length);
                output.write(payload);
            }
        };
    }

    public static <R> R decodeRawMessage(Decoder<R> decoder, byte[] rawMessage) {
        return PassthroughMessageCodec.runRawDecoder(decoder, rawMessage);
    }

    public static long decodeTransactionIDFromRawMessage(byte[] rawMessage) {
        Decoder<Long> decoder = new Decoder<Long>(){

            @Override
            public Long decode(PassthroughMessage.Type type, boolean shouldReplicate, long transactionID, long oldestTransactionID, DataInputStream input) throws IOException {
                return transactionID;
            }
        };
        return PassthroughMessageCodec.runRawDecoder(decoder, rawMessage);
    }

    public static PassthroughMessage.Type decodeTransactionTypeFromRawMessage(byte[] rawMessage) {
        Decoder<PassthroughMessage.Type> decoder = new Decoder<PassthroughMessage.Type>(){

            @Override
            public PassthroughMessage.Type decode(PassthroughMessage.Type type, boolean shouldReplicate, long transactionID, long oldestTransactionID, DataInputStream input) throws IOException {
                input.readLong();
                int ordinal = input.readInt();
                return PassthroughMessage.Type.values()[ordinal];
            }
        };
        return PassthroughMessageCodec.runRawDecoder(decoder, rawMessage);
    }

    public static byte[] serializeExceptionToArray(EntityException exception) {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutput = new ObjectOutputStream(byteOutput);){
            objectOutput.writeObject((Object)exception);
        }
        catch (IOException e) {
            Assert.unexpected(e);
        }
        return byteOutput.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityException deserializeExceptionFromArray(byte[] bytes) {
        EntityException exception = null;
        ByteArrayInputStream byteInput = new ByteArrayInputStream(bytes);
        try (ObjectInputStream objectInput = new ObjectInputStream(byteInput);){
            Object object = objectInput.readObject();
            exception = (EntityException)((Object)object);
        }
        catch (ClassNotFoundException e) {
            Assert.unexpected(e);
        }
        catch (IOException e) {
            Assert.unexpected(e);
        }
        return exception;
    }

    private static <R> R runRawDecoder(Decoder<R> decoder, byte[] rawMessage) {
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(rawMessage));
        R result = null;
        try {
            int ordinal = input.readInt();
            PassthroughMessage.Type type = PassthroughMessage.Type.values()[ordinal];
            boolean shouldReplicate = input.readBoolean();
            long transactionID = input.readLong();
            long oldestTransactionID = input.readLong();
            result = decoder.decode(type, shouldReplicate, transactionID, oldestTransactionID, input);
        }
        catch (IOException e) {
            Assert.unexpected(e);
        }
        return result;
    }

    public static interface Decoder<R> {
        public R decode(PassthroughMessage.Type var1, boolean var2, long var3, long var5, DataInputStream var7) throws IOException;
    }
}

